(function($) {'use strict';
	$(function() {

		$('.ct-counter').each(function() {
			var $item = $(this);
			var initHover = {
				icon_color1: $('.ct-icon-half-1', $item).css('color'),
				icon_color2: $('.ct-icon-half-2', $item).css('color'),
				icon_background: $('.ct-icon-inner', $item).css('background-color'),
				icon_border: $('.ct-icon', $item).css('border-left-color'),
				icon_box_border: $('.ct-counter-icon-circle-1', $item).css('border-left-color'),
				icon_box_shadow: $('.ct-icon', $item).css('box-shadow'),
				box_color: $('.ct-counter-inner', $item).css('background-color'),
				number_color: $('.ct-counter-number', $item).css('color'),
				text_color: $('.ct-counter-text', $item).css('color'),
			};
			$item.data('initHover', initHover);
			if($item.hasClass('ct-counter-effect-background-reverse') || $item.hasClass('ct-counter-effect-border-reverse')) {
				$('.ct-icon-inner', $item).prepend('<div class="ct-counter-animation"/>');
				if($item.hasClass('ct-counter-effect-border-reverse')) {
					$('.ct-counter-animation', $item).css('background-color', initHover.box_color);
				} else if($item.data('hover-background-color')) {
					$('.ct-counter-animation', $item).css('background-color', $item.data('hover-background-color'));
				}
			}
		});

		$('body').on('mouseenter', '.ct-counter a', function() {
			var $item = $(this).closest('.ct-counter');
			var initHover = $item.data('initHover');
			var $box = $item.closest('.ct-counter-box');
			$item.addClass('hover');
			if($item.data('hover-icon-color')) {
				if($box.hasClass('ct-counter-style-2')) {
					$('.ct-icon-half-1', $item).css('color', initHover.icon_box_border);
					$('.ct-icon-half-2', $item).css('color', initHover.icon_box_border);
					$('.ct-counter-icon-circle-1', $item).css('border-color', $item.data('hover-icon-color'));
					$('.ct-counter-icon-circle-1', $item).css('background-color', $item.data('hover-icon-color'));
					$('.ct-counter-icon-circle-2', $item).css('border-color', 'transparent');
				} else {
					if($item.hasClass('ct-counter-effect-background-reverse')) {
						$('.ct-icon', $item).css('border-color', $item.data('hover-icon-color'));
						$('.ct-icon-half-1', $item).css('color', $item.data('hover-icon-color'));
						$('.ct-icon-half-2', $item).css('color', $item.data('hover-icon-color'));
					}
					if($item.hasClass('ct-counter-effect-border-reverse')) {
						$('.ct-icon', $item).css('border-color', $item.data('hover-icon-color'));
						$('.ct-icon-inner', $item).css('background-color', $item.data('hover-icon-color'));
						$('.ct-icon-half-1', $item).css('color', '#ffffff');
						$('.ct-icon-half-2', $item).css('color', '#ffffff');
					}
					if($item.hasClass('ct-counter-effect-simple')) {
						$('.ct-icon-half-1', $item).css('color', $item.data('hover-icon-color'));
						$('.ct-icon-half-2', $item).css('color', $item.data('hover-icon-color'));
					}
				}
			}
			if($item.data('hover-numbers-color')) {
				$('.ct-counter-number', $item).css('color', $item.data('hover-numbers-color'));
			}
			if($item.data('hover-text-color')) {
				$('.ct-counter-text', $item).css('color', $item.data('hover-text-color'));
			}
			if($item.data('hover-background-color')) {
				$('.ct-counter-inner', $item).css('background-color', $item.data('hover-background-color'));
				$('.ct-counter-bottom-left, .ct-counter-bottom-right', $item).css('background-color', $item.data('hover-background-color'));
				$('.ct-counter-bottom svg', $item).css('fill', $item.data('hover-background-color'));
				if(!$box.hasClass('ct-counter-style-vertical')) {
					$('.ct-icon', $item).css('box-shadow', '0 0 0 5px '+$item.data('hover-background-color') + ', 0 0 0 6px ' + ($item.data('hover-icon-color') ? $item.data('hover-icon-color') : '#ffffff'));
				}
			}
		});

		$('body').on('mouseleave', '.ct-counter a', function() {
			var $item = $(this).closest('.ct-counter');
			var initHover = $item.data('initHover');
			$item.removeClass('hover');
			$('.ct-icon', $item).css('border-color', initHover.icon_border);
			$('.ct-icon-inner', $item).css('background-color', initHover.icon_background);
			$('.ct-icon-half-1', $item).css('color', initHover.icon_color1);
			$('.ct-icon-half-2', $item).css('color', initHover.icon_color2);
			$('.ct-icon', $item).css('box-shadow', initHover.icon_box_shadow),
			$('.ct-counter-icon-circle-1, .ct-counter-icon-circle-2', $item).css('border-color', initHover.icon_box_border);
			$('.ct-counter-icon-circle-1').css('background-color', 'transparent');
			$('.ct-counter-inner', $item).css('background-color', initHover.box_color);
			$('.ct-counter-bottom-left, .ct-counter-bottom-right', $item).css('background-color', initHover.box_color);
			$('.ct-counter-bottom svg', $item).css('fill', initHover.box_color);
			$('.ct-counter-number', $item).css('color', initHover.number_color);
			$('.ct-counter-text', $item).css('color', initHover.text_color);
		});

	});
})(jQuery);