<?php
/**
 * seed_wpnb Admin
 *
 * @package WordPress
 * @subpackage seed_wpnb
 * @since 0.1.0
 */


class SEED_WPNB_ADMIN
{
    public $plugin_version = SEED_WPNB_VERSION;
    public $plugin_name = SEED_WPNB_PLUGIN_NAME;

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;

   /**
     * Slug of the plugin screen.
     *
     * @since    1.0.0
     *
     * @var      string
     */
    protected $plugin_screen_hook_suffix = null;
    protected $plugin_screen_customizer_hook_suffix = null;

    /**
     * Load Hooks
     */
    function __construct( )
    {
        if(isset($_GET['page']) && $_GET['page'] == 'seed_wpnb' && !isset($_GET['tab'])){
            wp_redirect('options-general.php?page=seed_wpnb&tab=seed_wpnb_tab_pages');
        }

        if ( is_admin() && ( !defined( 'DOING_AJAX' ) ) ){
            add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts'  ) );
            add_action( 'admin_enqueue_scripts', array( &$this, 'deregister_scripts' ), PHP_INT_MAX );
            add_action( 'admin_menu', array( &$this, 'create_menus'  ) );
            
            // Render Options
            add_action( 'admin_init', array( &$this, 'reset_defaults' ) );
            add_action( 'admin_init', array( &$this, 'create_settings' ) );
            // Add link to options on the plugin page
            add_filter( 'plugin_action_links', array( &$this, 'plugin_action_links' ), 10, 2 );
            // Add or Upgrade DB
            add_action( 'admin_init', array( &$this, 'upgrade' ), 0 );
            //Display Pages
            add_action('seed_wpnb_render_page', array( &$this, 'display_pages' ));
            
            //Display Subscribers
            add_action('seed_wpnb_render_page', array( &$this, 'display_subscribers' ));
            
            // Handle action post
            add_action( 'admin_init', array( &$this, 'subscriber_actions' ), 0 );
            
        }
        
        if (defined( 'DOING_AJAX' )){
            // Save Page Ajqx
            add_action( 'wp_ajax_seed_wpnb_save_page', array(&$this,'save_page'));

            // Save Form Settings
            add_action( 'wp_ajax_seed_wpnb_save_form', array(&$this,'save_form'));

            // Save Language Settings
            add_action( 'wp_ajax_seed_wpnb_save_language', array(&$this,'save_language'));

            // Save Language Settings Details
            add_action( 'wp_ajax_seed_wpnb_save_language_detail', array(&$this,'save_language_detail'));

            // Save Page HTML Ajqx
            add_action( 'wp_ajax_seed_wpnb_get_html', array(&$this,'get_html'));
            add_action( 'wp_ajax_seed_wpnb_save_html', array(&$this,'save_html'));
            
            // Background API Ajax
            add_action( 'wp_ajax_seed_wpnb_backgrounds', array(&$this,'backgrounds'));
            
            // Sideload Background API Ajax
            add_action( 'wp_ajax_seed_wpnb_backgrounds_sideload', array(&$this,'backgrounds_sideload'));
            
            // Theme Load Api
            add_action( 'wp_ajax_seed_wpnb_load_theme', array(&$this,'load_theme'));
            
            //Subscribe Callback
            add_action( 'wp_ajax_seed_wpnb_subscribe_callback', array(&$this,'subscribe_callback') );
            add_action( 'wp_ajax_nopriv_seed_wpnb_subscribe_callback', array(&$this,'subscribe_callback') );
            
            // Save Emaillist Settings
            add_action( 'wp_ajax_seed_wpnb_save_emaillist_settings', array(&$this,'save_emaillist_settings') );
            
            // Save Get Email Lists
            add_action( 'wp_ajax_seed_wpnb_get_email_lists', array(&$this,'get_email_lists') );

            // Export page settings
            add_action( 'wp_ajax_seed_wpnb_export_page_settings', array(&$this,'export_page_settings') );

            // Import page settings
            add_action( 'wp_ajax_seed_wpnb_import_page_settings', array(&$this,'import_page_settings') );


            // Activate License
            add_action( 'wp_ajax_seed_wpnb_activate_license', array(&$this,'activate_license'));
            
        }

    }
    

    /**
     * Return an instance of this class.
     *
     * @since     1.0.0
     *
     * @return    object    A single instance of this class.
     */
    public static function get_instance() {

        // If the single instance hasn't been set, set it now.
        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    function deregister_scripts(){
        if(isset($_GET['page']) && $_GET['page'] == 'seed_wpnb_customizer'){
            if(isset($_GET['seed_wpnb_debug'])){
            // only ones we need are: common|utils|wp-auth-check|media-upload|seed_wpnb-customizer-js
            $d = array();
            if(!empty($_GET['d'])){
                $d = explode("|",$_GET['d']); 
            }
            global $wp_scripts;
             foreach( $wp_scripts->queue as $handle ) :
                echo $handle . '|';
                if(!empty($d)){
                if(!in_array($handle,$d)){
                    wp_dequeue_script( $handle );
                    wp_deregister_script( $handle );
                }
                }
            endforeach;
            }
        //die();
        }
       
    }
    
    /**
     * Get pages and put in assoc array
     */
    function get_pages(){
        $pages = get_pages();
        $page_arr = array();
        if(is_array($pages)){
            foreach($pages as $k=>$v){
                $page_arr[$v->ID] = $v->post_title;
            }
        }
        return $page_arr;
    }


    /**
     *  Activate License
     */
    function activate_license(){
        if(check_ajax_referer('seed_wpnb_activate_license') && isset($_GET['apikey'])){
            $api_key = $_GET['apikey'];
            $params = array(
                'action'     => 'info',
                'license_key'=> $api_key,
                'slug'       => SEED_WPNB_SLUG,
                'domain'        => home_url(),
                'installed_version' => SEED_WPNB_VERSION,
                'token'      => get_option('seed_wpnb_token'),
            );
            $request = wp_remote_post( SEED_WPNB_API_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $params ) );
           
            if ( ! is_wp_error( $request ) ) {
                $request = wp_remote_retrieve_body( $request );
                $arequest = json_decode($request);
                $nag = $arequest->message;

                update_option('seed_wpnb_license_key',$api_key);
                
                update_option('seed_wpnb_api_message',$nag);
                if($arequest->status == '200'){
                    update_option('seed_wpnb_api_nag','');
                    update_option('seed_wpnb_a',true);
                    update_option('seed_wpnb_per',$arequest->per);
                }elseif($arequest->status == '401'){
                    update_option('seed_wpnb_api_nag',$nag);
                    update_option('seed_wpnb_a',false);
                    update_option('seed_wpnb_per','');
                }elseif($arequest->status == '402'){
                    update_option('seed_wpnb_api_nag',$nag);
                    update_option('seed_wpnb_a',false);
                    update_option('seed_wpnb_per',$arequest->per);

                }     

                echo $request;

            }else{
                $request = false;
            }
            exit();
        }
    }



    
    /**
     * Upgrade setting pages. This allows you to run an upgrade script when the version changes.
     *
     */
    function upgrade( )
    {
        // get current version
        $seed_wpnb_current_version = get_option( 'seed_wpnb_version' );
        $upgrade_complete = false;
        if ( empty( $seed_wpnb_current_version ) ) {
            $seed_wpnb_current_version = 0;
        }

        if($seed_wpnb_current_version === 0){
            // Load Defaults if new install
            //require_once(SEED_WPNB_PLUGIN_PATH.'inc/defaults.php');
            
            //Try to upgrade settings from 2 to 3
            // $mapping = array(
            //     'api_key' => 'seedprod_api_key',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     // '' => '',
            //     );

            // $old_fields = array();
            // $old_fields = get_option('csp2_option_tree');
            // var_dump($old_fields);
            // if(!empty($old_fields)){
            //     foreach($seed_wpnb_settings_deafults as $k=>$v){
            //         foreach($v as $k2=>$v2){
            //             if(array_key_exists($k2,$mapping)){
            //                 if(!empty($old_fields[$mapping[$k2]]))
            //                     $seed_wpnb_settings_deafults[$k][$k2] = $old_fields[$mapping[$k2]];
            //             }
            //         }
            //     }
            // }
            // var_dump($seed_wpnb_settings_deafults);

            //foreach($seed_wpnb_settings_deafults as $k=>$v){
               // update_option( $k, $v );
            //}
        }
// var_dump($seed_wpnb_current_version);
// var_dump(SEED_WPNB_VERSION);
// var_dump(version_compare( $seed_wpnb_current_version,SEED_WPNB_VERSION));
        if ( version_compare( $seed_wpnb_current_version,SEED_WPNB_VERSION) === -1) {
            // Upgrade db if new version
            $this->database_setup();
            $upgrade_complete = true;

        }

        if($upgrade_complete){
            update_option( 'seed_wpnb_version', SEED_WPNB_VERSION );
        }
        //var_dump($upgrade_complete);
        
        // Sample script to update field if it's changed to a different tab.
        // if ( version_compare( SEED_WPNB_VERSION,$seed_wpnb_current_version ) === 1) {
        //     $old_fields = array();
        //     $old_fields = get_option('seed_wpnb_options_1');
        //     $old_fields = $old_fields + get_option('seed_wpnb_options_1');
        
        //     $new_fields = array();
        //     foreach ($this->options as $k) {
        //         switch ($k['type']) {
        //             case 'setting':
        //             case 'section':
        //             case 'tab':
        //                 break;
        //             default:
        //                 if(isset($old_fields[$k['id']])){
        //                     $new_fields[$k['setting_id']][$k['id']] = $old_fields[$k['id']];
        //                 }
        
        
        //         }
        //     }
        //     var_dump($old_fields);
        //     var_dump($new_fields);
        
        // }
    }
    
    
    /**
     * Create Database to Store Emails
     */
    function database_setup() {

        global $wpdb;
        $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
        //if( $wpdb->get_var("SHOW TABLES LIKE '$tablename'") != $tablename ){
            $sql = "CREATE TABLE `$tablename` (
              id int(11) unsigned NOT NULL AUTO_INCREMENT,
              path varchar(255) DEFAULT NULL,
              priority int(11) unsigned DEFAULT 10,
              name varchar(255) DEFAULT NULL,
              type varchar(255) DEFAULT NULL,
              settings text DEFAULT NULL,
              html text DEFAULT NULL,
              meta text DEFAULT NULL,
              mailprovider varchar(255) DEFAULT NULL,
              active int(11) NOT NULL DEFAULT '0',
              start_date timestamp NULL,
              end_date timestamp NULL,
              created timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
              PRIMARY KEY  (id)
            );";
        
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            dbDelta($sql);
        //}

        global $wpdb;
        $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
        //if( $wpdb->get_var("SHOW TABLES LIKE '$tablename'") != $tablename ){
            $sql = "CREATE TABLE `$tablename` (
              id int(11) unsigned NOT NULL AUTO_INCREMENT,
              page_id int(11) NOT NULL,
              email varchar(255) DEFAULT NULL,
              fname varchar(255) DEFAULT NULL,
              lname varchar(255) DEFAULT NULL,
              ref_url varchar(255) DEFAULT NULL,
              clicks int(11) NOT NULL DEFAULT '0',
              conversions int(11) NOT NULL DEFAULT '0',
              referrer int(11) NOT NULL DEFAULT '0',
              ip varchar(255) DEFAULT NULL,
              meta text DEFAULT NULL,
              optin_confirm int(11) NOT NULL DEFAULT '0',
              created timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
              PRIMARY KEY  (id)
            );";
        
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            dbDelta($sql);
        //}
    }

    /**
     * Export Page_Settings
     *
     */
    function export_page_settings( )
    {
        if(check_ajax_referer('seed_wpnb_export_page_settings')){
                //Get page settings
                $page_id = '';
                if(isset($_GET['page_id'])){
                    $page_id = $_GET['page_id'];
                }
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                $sql = "SELECT * FROM $tablename WHERE id= %d";
                $safe_sql = $wpdb->prepare($sql,$page_id);
                $page = $wpdb->get_row($safe_sql);

                // Check for base64 encoding of settings
                if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
                    $settings = unserialize(base64_decode($page->settings));
                } else {
                    $settings = unserialize($page->settings);
                }

                echo json_encode($settings);

        }
        exit();
    }

    /**
     * Import Page_Settings
     *
     */
    function import_page_settings( )
    {
        if(check_ajax_referer('seed_wpnb_import_page_settings')){
                $page_id = '';
                if(isset($_GET['page_id'])){
                    $page_id = $_GET['page_id'];
                }

                $settings = json_decode(file_get_contents('php://input'),TRUE);

               
                // if(json_last_error() != JSON_ERROR_NONE){
                //     echo '0';
                // }
                $r = false;
              
                if(!empty($settings['check_mic'])){
                    global $wpdb;
                    $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                    // Update Row
                    $r = $wpdb->update( 
                        $tablename, 
                        array( 
                            'settings' => base64_encode(serialize($settings)),
                            
                        ), 
                        array( 'ID' => $page_id ), 
                        array( 
                            '%s',
       
                        ), 
                        array( '%d' ) 
                    );
                }
            
                if($r !== false){
                    echo $page_id;
                }else{
                    echo 'false';
                }
                
        }
        exit();
    }

    function save_html( ){
        if(check_ajax_referer('seed_wpnb_save_html','html_wpnonce')){
            $page_id = '';
            $html = '';

            if(isset($_GET['page_id'])){
                $page_id = $_GET['page_id'];
            }

            $html = file_get_contents('php://input');

            // DB setup
            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
          
            // Update Row
            $r = $wpdb->update( 
                $tablename, 
                array( 
                    'html' => $html,     
                ), 
                array( 'ID' => $page_id ), 
                array( 
                    '%s',
                ), 
                array( '%d' ) 
            );

        }
        exit();
    }

    function save_form( ){
        if(check_ajax_referer('seed_wpnb_save_form')){
            $settings_name = $_REQUEST['settings_name'];
            $settings = $_REQUEST;
            unset($settings['action']);
            unset($settings['_wpnonce']);
            $r = update_option($settings_name,stripslashes_deep($settings));
            echo '1';

        }
        exit();
    }

    function save_language( ){
        if(check_ajax_referer('seed_wpnb_save_language')){
            $settings_name = $_REQUEST['settings_name'];
            $settings = $_REQUEST;
            unset($settings['action']);
            unset($settings['_wpnonce']);
            $r = update_option($settings_name,stripslashes_deep($settings));
            echo '1';

        }
        exit();
    }

    function save_language_detail( ){
        if(check_ajax_referer('seed_wpnb_save_language_detail')){
            $settings_name = $_REQUEST['settings_name'];
            $settings = $_REQUEST;
            unset($settings['action']);
            unset($settings['_wpnonce']);
            $r = update_option($settings_name,stripslashes_deep(array_filter($settings)));
            echo '1';

        }
        exit();
    }

    /**
     * Render html to Databae
     *
     */
    function get_html( ){
       
        if(check_ajax_referer('seed_wpnb_get_html')){
            $page_id = '';

            if(isset($_GET['page_id'])){
                $page_id = $_GET['page_id'];
            }

            // Get Page
            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
            $sql = "SELECT * FROM $tablename WHERE id= %d";
            $safe_sql = $wpdb->prepare($sql,$page_id);
            $page = $wpdb->get_row($safe_sql);
            $html = '';

            // Check for base64 encoding of settings
            if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
                $settings = unserialize(base64_decode($page->settings));
            } else {
                $settings = unserialize($page->settings);
            }

            // render
            $upload_dir = wp_upload_dir();
            if(is_multisite()){
                $path = $upload_dir['baseurl'].'/seedprod/'.get_current_blog_id().'/template-'.$page_id.'/index.php';
            }else{
                $path = $upload_dir['basedir'].'/seedprod/template-'.$page_id.'/index.php';
            }

            ob_start();
            if(file_exists($path)){
                require_once($path);
            }else{
                require_once(SEED_WPNB_PLUGIN_PATH.'template/index.php');
            }
            $html = ob_get_clean();

            echo $html; 
        }
        exit();
    }
    
    
    /**
     * Reset the settings page. Reset works per settings id.
     *
     */
    function save_page( )
    {
        if(check_ajax_referer('seed_wpnb_save_page')){


            // Vars 
            $r = false;
            $page_id = $_REQUEST['page_id'];
            //$url = $_REQUEST['url'];
            $settings = stripslashes_deep($_REQUEST);
            $settings_arr = $settings;

            if(empty($settings['enable_bar'])){
                $bar_enabled = 0;
            }elseif($settings['enable_bar'] == 1){
                $bar_enabled = 1;
            }elseif($settings['enable_bar'] == 2){
                $bar_enabled = 2;
            }

            $start_date = NULL;
            if(!empty($settings['scheduled_start_date'])){
                $start_date = date( 'Y-m-d H:i:s',strtotime($settings['scheduled_start_date']));
            }

            $end_date = NULL;
            if(!empty($settings['scheduled_end_date'])){
                $end_date = date( 'Y-m-d H:i:s',strtotime($settings['scheduled_end_date']));
            }


            $name = $settings['name'];
            $priority = $settings['priority'];
            $mailprovider = $settings['emaillist'];
            unset($settings['import_settings']);
            unset($settings['html']);
            $settings = base64_encode(serialize($settings));


            $r = false;

            // Make sure these fields are not empty

            $error_message_map = array(
                'background_color' => '<strong>Background Color</strong><br>under the Background Settings Section',
                'button_color' => '<strong>Elements Color</strong><br>under the Elements Color Section',
                'form_color' => '<strong>Form Input Background Color</strong><br>under the Elements Color Section',
                'text_color' => '<strong>Text Color</strong><br>under the Typography Section',
                'txt_subscribe_button' => '<strong>Subscribe Button Text</strong><br>under the Translate Text Section',
                'txt_email_field' => '<strong>Email Field Text</strong><br>under the Translate Text Section',
                'txt_name_field' => '<strong>Name Field Text </strong><br>under the Translate Text Section',
                'txt_already_subscribed_msg' => '<strong>Already Subscribed Text</strong><br>under the Translate Text Section',
                'txt_invalid_email_msg' => '<strong>Invalid Email Text</strong><br>under the Translate Text Section',
                'txt_invalid_name_msg' => '<strong>Invalid Name Text</strong><br>under the Content Container Section',
                'check_mic' => ''
            );

            $validated = true;
            $error_message = array();

            $v_fields = array(
                'background_color',
                'button_color',
                'form_color',
                'text_color',
                'txt_subscribe_button',
                'txt_email_field',
                'txt_name_field',
                'txt_already_subscribed_msg',
                'txt_invalid_email_msg',
                'txt_invalid_name_msg',
                'check_mic');
            foreach($v_fields as $v){

                if(empty($settings_arr[$v])){
                    $validated = false;
                    if(!empty($error_message_map[$v])){
                    $error_message[] = $error_message_map[$v];
                    }
                }
            }

            if($validated){
                
                // DB setup
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
              
                // Update Row
                $r = $wpdb->update( 
                	$tablename, 
                	array( 
                		'name' => stripslashes($name),
                		'active' => $bar_enabled,
                        'priority' => $priority,
                		'settings' => $settings,
                        'mailprovider' => $mailprovider,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                		
                	), 
                	array( 'ID' => $page_id ), 
                	array( 
                		'%s',
                		'%s',
                		'%s',
                        '%s',
                        '%s',
                        '%s',
                	), 
                	array( '%d' ) 
                );
            }
            //var_dump($r);
            
            if($r !== false){
                echo 'true';
            }else{
                echo json_encode($error_message);
            }
            exit();
        }
    }
    
    /**
     * Get Email Lists
     *
     */
    function get_email_lists( )
    {
        if(check_ajax_referer('seed_wpnb_get_email_lists')){
            $emaillist = $_REQUEST['emaillist'];
            $mod = $_REQUEST['mod'];
            if(!empty($mod )){
                $emaillist = $mod;
            }
            $r = call_user_func('seed_wpnb_get_'.$emaillist.'_lists');
            echo $r;
            
        }
        exit();
    }
    
    /**
     * Save Emaillist Settings
     *
     */
    function save_emaillist_settings( )
    {
        if(check_ajax_referer('seed_wpnb_save_emaillist_settings')){
            $settings_name = $_REQUEST['settings_name'];
            $r = update_option($settings_name,stripslashes_deep($_REQUEST));
            echo '1';
            
        }
        exit();
    }
    
    
    /**
     * Load theme
     *
     */
    function load_theme( )
    {
        if(check_ajax_referer('seed_wpnb_load_theme')){


            //$r = false;
           
            // Vars
            $page_id = '';
            if(isset($_REQUEST['page_id'])){
                $page_id = sanitize_text_field($_REQUEST['page_id']);
            }

            $type = '';
            if(isset($_REQUEST['type'])){
                $type = sanitize_text_field($_REQUEST['type']);
            }

            $name = '';
            if(isset($_REQUEST['name'])){
                $name = sanitize_text_field($_REQUEST['name']);
            }

            $path = '';
            if(isset($_REQUEST['path'])){
                $path = sanitize_text_field($_REQUEST['path']);
            }


            // Create new page if page_id -1
            if($page_id == '-1'){
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                $default_settings = seed_wpnb_get_page_default_settings();

                $wpdb->insert( 
                    $tablename, 
                    array( 
                        'name' => stripslashes($name), 
                        'type' => 'bar',
                        'settings' => serialize($default_settings) ,
                    ), 
                    array( 
                        '%s', 
                        '%s',
                        '%s' 
                    ) 
                );
                $page_id = $wpdb->insert_id;
            }

            
            $theme_id = '';
            if(isset($_REQUEST['theme'])){
                $theme_id = $_REQUEST['theme'];
            }
            
            $theme = array();

            if($theme_id != '0'){
            if($theme_id != ''){
                // Get theme specifics
                if ( false === ( get_transient( 'seed_wpnb_theme_id_'.$theme_id ) ) ) {
                   //echo 'miss';
                    $url = SEED_WPNB_THEME_API_URL.'?theme_id='.$theme_id; 
                    $response = wp_remote_get( $url );
                    if ( is_wp_error( $response ) ) {
                        $error_message = $response->get_error_message();
                        echo "false";
                        exit();
                    }else{
                        $theme = $response['body'];
                        $theme_arr = json_decode($theme);
                        if(!empty($theme_arr->id)){
                            set_transient('seed_wpnb_theme_id_'.$theme_id,$response['body'],432000);
                        }else{
                            echo "false";
                            exit(); 
                        }
                        
                    }
                }else{
                    //echo 'hit';
                    $theme =  get_transient( 'seed_wpnb_theme_id_'.$theme_id);
                }
                $theme = json_decode($theme);
            }
        }
            
            //var_dump(json_decode($theme->settings, TRUE));


            
             // Merge theme into curretn theme
            if(!empty($page_id)){
                //Get page settings
                
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                $sql = "SELECT * FROM $tablename WHERE id= %d";
                $safe_sql = $wpdb->prepare($sql,$page_id);
                $page = $wpdb->get_row($safe_sql);

                // Check for base64 encoding of settings
                if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
                    $settings = unserialize(base64_decode($page->settings));
                } else {
                    $settings = unserialize($page->settings);
                }

 
                if(!empty($theme->id)){
                if($settings !== false){

                    //var_dump($settings);
                    //var_dump(json_decode($theme->settings, TRUE));
                    $settings = array_merge($settings,json_decode($theme->settings, TRUE));
                    //var_dump($settings);
                    $settings['theme_css'] = $theme->css;
                    $settings['theme_scripts'] = $theme->scripts;
                    $settings['theme'] = $theme->id;
                    
                
                    // Save settings back to page
                    global $wpdb;
                    $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                    $r = false;
                    // Update Row
                    $r = $wpdb->update( 
                    	$tablename, 
                    	array( 
                    		'settings' => base64_encode(serialize($settings)),
                    		
                    	), 
                    	array( 'ID' => $page_id ), 
                    	array( 
                    		'%s',
       
                    	), 
                    	array( '%d' ) 
                    );

                }
                }
                $r = true;
                if($r !== false){
                    echo $page_id;
                }else{
                    echo 'false';
                }       
            }
                
            exit();
        }
    }
    
    /**
     * Reset the settings page. Reset works per settings id.
     *
     */
    function backgrounds( )
    {
        if(check_ajax_referer('seed_wpnb_backgrounds')){
           
            $page = '';
            if(isset($_REQUEST['page'])){
                $page = $_REQUEST['page'];
                $page = '?page='.$page;
            }
            
            if ( false === ( get_transient( 'seed_wpnb_backgrounds_page_'.$page ) ) ) {
                //echo 'miss';
                $url = SEED_WPNB_BACKGROUND_API_URL.$page.'&api_key='.get_option('seed_wpnb_license_key').'&domain='.urlencode(home_url()); 
                $response = wp_remote_get( $url );
                //var_dump($response);
                if ( is_wp_error( $response ) ) {
                    $error_message = $response->get_error_message();
                    echo "Something went wrong: $error_message";
                }else{
                    $response_code = wp_remote_retrieve_response_code( $response );
                    if($response_code == '200' && seed_wpnb_cu()){
                        set_transient('seed_wpnb_backgrounds_page_'.$page,$response['body'],604800);
                        echo $response['body'];
                    }else{
                        echo 'There was an issue loading the backgrounds. Please make sure you have entered a valid license key in the plugin or try again later.';
                    }
                    
                }
            }else{
                //echo 'hit';
                echo get_transient( 'seed_wpnb_backgrounds_page_'.$page );
            }
                    


            exit();
        }
    }
    
    /**
     * Reset the settings page. Reset works per settings id.
     *
     */
    function backgrounds_sideload( )
    {
        if(check_ajax_referer('seed_wpnb_backgrounds_sideload')){
           
            $image = '';
            if(isset($_REQUEST['image'])){
                $image =  urldecode($_REQUEST['image']);
                $file = media_sideload_image($image.'&type=.jpg', 0, null, 'src' );
                
                if ( is_wp_error( $file ) ) {
                    $error_message = $file->get_error_message();
                    echo "0";
                    exit();
            	}else{
            	   echo $file; 
            	}
                
            }
            
            exit();
        }
    }


    /**
     * Reset the settings page. Reset works per settings id.
     *
     */
    function reset_defaults( )
    {
        if ( isset( $_POST[ 'seed_wpnb_reset' ] ) ) {
            $option_page = $_POST[ 'option_page' ];
            check_admin_referer( $option_page . '-options' );
            require_once(SEED_WPNB_PLUGIN_PATH.'inc/default-settings.php');

            $_POST[ $_POST[ 'option_page' ] ] = $seed_wpnb_settings_deafults[$_POST[ 'option_page' ]];
            add_settings_error( 'general', 'seed_wpnb-settings-reset', __( "Settings reset." ), 'updated' );
        }
    }

    /**
     * Properly enqueue styles and scripts for our theme options page.
     *
     * This function is attached to the admin_enqueue_scripts action hook.
     *
     * @since  0.1.0
     * @param string $hook_suffix The name of the current page we are on.
     */
    function admin_enqueue_scripts( $hook_suffix )
    {
        $pages = array(
            'settings_page_seed_wpnb'
        );


        if ( $hook_suffix ==  'settings_page_seed_wpnb_form'){
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script('jquery-ui-core');
            wp_enqueue_script( 'jquery-ui-sortable' );
        }

        if ( $hook_suffix ==  'settings_page_seed_wpnb_language'){
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script('jquery-ui-core');
            wp_enqueue_script( 'jquery-ui-sortable' );
        }

        if ( $hook_suffix ==  'settings_page_seed_wpnb_language_detail'){
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script('jquery-ui-core');
        }
        
        if ( $hook_suffix ==  'settings_page_seed_wpnb_themes'){
            wp_enqueue_script( 'images-loaded', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.imagesloaded/3.2.0/imagesloaded.pkgd.min.js', false, $this->plugin_version );
            wp_enqueue_script( 'jquery-masonry' );
            wp_enqueue_style( 'seed_wpnb-framework-css', SEED_WPNB_PLUGIN_URL . 'admin/settings-style.css', false, $this->plugin_version );
        }

        if ( in_array($hook_suffix,$pages) ){
            wp_enqueue_script( 'media-upload' );
            wp_enqueue_script( 'jquery-ui-sortable' );
            wp_enqueue_script( 'wp-lists' );
            wp_enqueue_script( 'seed_wpnb-framework-js', SEED_WPNB_PLUGIN_URL . 'admin/settings-scripts.js', array( 'jquery' ), $this->plugin_version );
            wp_enqueue_script( 'theme-preview' );
            wp_enqueue_style( 'thickbox' );
            wp_enqueue_style( 'media-upload' );
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_style( 'seed_wpnb-framework-css', SEED_WPNB_PLUGIN_URL . 'admin/settings-style.css', false, $this->plugin_version );
            wp_enqueue_style( 'font-awesome', '//netdna.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.css', false, $this->plugin_version );
            wp_enqueue_script( 'seed-wpnb-backend-script', plugins_url('admin/backend-scripts.js',dirname(__FILE__)), array( 'jquery' ),SEED_WPNB_VERSION, true );  
			$data = array( 
                'delete_confirm' => __( 'Are you sure you want to DELETE all pages?' , 'seedprod-wp-notification-bar-pro'),
            );
			wp_localize_script( 'seed-wpnb-backend-script', 'seed_wpnb_msgs', $data );
        }
        
        if($hook_suffix == $this->plugin_screen_customizer_hook_suffix){
            wp_enqueue_script( 'media-upload' );
            wp_enqueue_script( 'seed_wpnb-customizer-js', SEED_WPNB_PLUGIN_URL . 'customizer/customizer-scripts.js', array( 'jquery' ), $this->plugin_version );
            wp_enqueue_style( 'thickbox' );
            wp_enqueue_style( 'media-upload' );
            wp_enqueue_style( 'seed_wpnb-customizer-css', SEED_WPNB_PLUGIN_URL . 'customizer/customizer-style.css', false, $this->plugin_version );
        }
    }

    /**
     * Creates WordPress Menu pages from an array in the config file.
     *
     * This function is attached to the admin_menu action hook.
     *
     * @since 0.1.0
     */
    function create_menus( )
    {

    $this->plugin_screen_hook_suffix = add_options_page(
            __( "Notification Bar Pro", 'seedprod-wp-notification-bar-pro' ),
            __( "Notification Bar Pro", 'seedprod-wp-notification-bar-pro' ),
            'manage_options',
            'seed_wpnb',
            array( &$this , 'option_page' )
            );
            
    $this->plugin_screen_customizer_hook_suffix = add_submenu_page(
            NULL,
            __( "Customizer", 'seedprod-wp-notification-bar-pro' ),
            __( "Customizer", 'seedprod-wp-notification-bar-pro' ),
            'manage_options',
            'seed_wpnb_customizer',
            array( &$this , 'customizer' )
            );
            
    $this->plugin_screen_themes_hook_suffix = add_submenu_page(
            NULL,
            __( "Themes", 'seedprod-wp-notification-bar-pro' ),
            __( "Themes", 'seedprod-wp-notification-bar-pro' ),
            'manage_options',
            'seed_wpnb_themes',
            array( &$this , 'themes_page' )
            );

    $this->plugin_screen_form_hook_suffix = add_submenu_page(
        NULL,
        __( "Forms", 'seedprod-wp-notification-bar-pro' ),
        __( "Forms", 'seedprod-wp-notification-bar-pro' ),
        'manage_options',
        'seed_wpnb_form',
        array( &$this , 'form_page' )
        );

    $this->plugin_screen_language_hook_suffix = add_submenu_page(
        NULL,
        __( "Languages", 'seedprod-wp-notification-bar-pro' ),
        __( "Languages", 'seedprod-wp-notification-bar-pro' ),
        'manage_options',
        'seed_wpnb_language',
        array( &$this , 'language_page' )
        );

    $this->plugin_screen_language_detail_hook_suffix = add_submenu_page(
        NULL,
        __( "Language Detail", 'seedprod-wp-notification-bar-pro' ),
        __( "Language Detail", 'seedprod-wp-notification-bar-pro' ),
        'manage_options',
        'seed_wpnb_language_detail',
        array( &$this , 'language_detail_page' )
        );
      
    $this->plugin_screen_integrations_hook_suffix = add_submenu_page(
            NULL,
            __( "Integrations", 'seedprod-wp-notification-bar-pro' ),
            __( "Integrations", 'seedprod-wp-notification-bar-pro' ),
            'manage_options',
            'seed_wpnb_integrations',
            array( &$this , 'integrations_page' )
            );
    
    
    $this->plugin_screen_importer_hook_suffix = add_submenu_page(
            NULL,
            __( "Import", 'seedprod-wp-notification-bar-pro' ),
            __( "Import", 'seedprod-wp-notification-bar-pro' ),
            'manage_options',
            'seed_wpnb_import',
            array( &$this , 'import_page' )
            );
    
    }



    function import_page()
    {
        require_once(SEED_WPNB_PLUGIN_PATH.'admin/import.php');
    }

    


    /**
     * Display settings link on plugin page
     */
    function plugin_action_links( $links, $file )
    {
        $plugin_file = "seedprod-notification-bar-pro/seedprod-wp-notification-bar-pro.php";

        if ( $file == $plugin_file ) {

            $settings_link = '<a href="options-general.php?page=seed_wpnb&tab=seed_wpnb_tab_pages">Settings</a>';
            array_unshift( $links, $settings_link );
        }
        return $links;
    }


    /**
     * Allow Tabs on the Settings Page
     *
     */
    function plugin_options_tabs( )
    {
        $menu_slug   = null;
        $page        = $_REQUEST[ 'page' ];
        $uses_tabs   = false;
        $current_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : false;

        //Check if this config uses tabs
        foreach ( seed_wpnb_get_options() as $v ) {
            if ( $v[ 'type' ] == 'tab' ) {
                $uses_tabs = true;
                break;
            }
        }

        // If uses tabs then generate the tabs
        if ( $uses_tabs ) {
            echo '<h2 class="nav-tab-wrapper" style="padding-left:20px">';
            $c = 1;
            foreach ( seed_wpnb_get_options() as $v ) {
                    if ( isset( $v[ 'menu_slug' ] ) ) {
                        $menu_slug = $v[ 'menu_slug' ];
                    }
                    if ( $menu_slug == $page && $v[ 'type' ] == 'tab' ) {
                        $active = '';
                        if ( $current_tab ) {
                            $active = $current_tab == $v[ 'id' ] ? 'nav-tab-active' : '';
                        } elseif ( $c == 1 ) {
                            $active = 'nav-tab-active';
                        }

                        if(empty($v[ 'icon' ])){
                            $v[ 'icon' ] = '';
                        }

                        echo '<a class="nav-tab ' . $active . '" href="?page=' . $menu_slug . '&tab=' . $v[ 'id' ] . '"><i class="'.$v[ 'icon' ].'"></i> ' . $v[ 'label' ] . '</a>';
                        $c++;
                    }
            }
            if(seed_wpnb_cu()){
            echo '<a class="nav-tab " href="http://support.seedprod.com/article/126-coming-soon-page-pro-documentation-version-5" target="_blank" style="float:right;"><i class="fa fa-life-ring"></i> Support</a>';
            }
            if(!defined('SEED_WPNB_API_KEY')){
            echo '<a class="nav-tab " href="'.admin_url().'options-general.php?page=seed_wpnb_welcome" style="float:right;"><i class="fa fa-hashtag"></i> License</a>';
            }
            
            echo '</h2>';

        }
    }

    /**
     * Get the layout for the page. classic|2-col
     *
     */
    function get_page_layout( )
    {
        $layout = 'classic';
        foreach ( seed_wpnb_get_options() as $v ) {
            switch ( $v[ 'type' ] ) {
                case 'menu';
                    $page = $_REQUEST[ 'page' ];
                    if ( $page == $v[ 'menu_slug' ] ) {
                        if ( isset( $v[ 'layout' ] ) ) {
                            $layout = $v[ 'layout' ];
                        }
                    }
                    break;
            }
        }
        return $layout;
    }
    
    
    function themes_page( ){
       // Get themes
        $paged = '?page=1';
        if(isset($_REQUEST['paged'])){
            $paged = $_REQUEST['paged'];
            $paged = '?page='.$paged;
        }
        
        $themes = array();
        if ( false === ( get_transient( 'seed_wpnb_themes_page_'.$paged ) ) ) {
            //echo 'miss';
            $url = SEED_WPNB_THEME_API_URL.$paged.'&api_key='.get_option('seed_wpnb_license_key').'&domain='.urlencode(home_url()); 
            //var_dump($url);
            $response = wp_remote_get( $url );

            //if ( is_wp_error( $response ) ) {
            if ( 1 == 1 ) {
                //$error_message = $response->get_error_message();
                    $themes = "<a class='seed_wpnb_no_themes' href='?theme=0'>Click to continue &#8594;</a>";
            }else{
                $response_code = wp_remote_retrieve_response_code( $response );
                if($response_code == '200' && seed_wpnb_cu()){
                    set_transient('seed_wpnb_themes_page_'.$paged,$response['body'],604800);
                    $themes = $response['body'];
                }else{
                    $themes = "<br><br>Please enter a valid license key to access the themes. You can still proceed to create a page with the default theme.<br> <a class='seed_wpnb_no_themes' href='?theme=0'>Click to continue &#8594;</a>";
                }
            }
        }else{
            //echo 'hit';
            $themes = get_transient( 'seed_wpnb_themes_page_'.$paged );
        }
        
       
       require_once(SEED_WPNB_PLUGIN_PATH.'admin/themes.php');
    }

    function form_page( ){
        require_once(SEED_WPNB_PLUGIN_PATH.'admin/form.php');
    }

    function language_page( ){
        require_once(SEED_WPNB_PLUGIN_PATH.'admin/language.php');
    }

    function language_detail_page( ){
        require_once(SEED_WPNB_PLUGIN_PATH.'admin/language_detail.php');
    }
    
    function integrations_page( ){
       require_once(SEED_WPNB_PLUGIN_PATH.'admin/integrations.php');
    }
    
    function subscribers_page( ){
       require_once(SEED_WPNB_PLUGIN_PATH.'admin/subscribers.php');
    }
    
    function customizer( ){
    //var_dump($_GET['seed_wpnb_customize']);

        

    // Page auth make sure user can perform this action
    
    // Page Info
    $page_id = 0;
    if(isset($_GET['seed_wpnb_customize'])){
        $page_id = $_GET['seed_wpnb_customize'];
    }
    
    
    $fontfile = SEED_WPNB_PLUGIN_PATH . 'customizer/webfonts.json';
    $fonts_json = file_get_contents($fontfile);
    $fonts[0] = 'Inherit';
    $fonts['Standard Fonts'] = array(
        "Helvetica, Arial, sans-serif"                         => "Helvetica, Arial, sans-serif",
        "'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
        "'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
        "'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
        "Courier, monospace"                                   => "Courier, monospace",
        "Garamond, serif"                                      => "Garamond, serif",
        "Georgia, serif"                                       => "Georgia, serif",
        "Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
        "'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
        "'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
        "'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
        "'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
        "'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
        "Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
        "'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
        "'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
        "Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
    );
    $gfonts = json_decode($fonts_json,true);
    foreach($gfonts as $k => $v){
        $font_families["'".$k."'"] = $k;
    }
    $fonts['Google Fonts'] = $font_families;

    $font_families = $fonts;
    
    $emaillist = apply_filters( 'seed_wpnb_providers', array(
                                    'database' => __( 'Database', 'seedprod-wp-notification-bar-pro' ),
                                    'feedblitz' => 'FeedBlitz',
                                    'drip' => 'Drip',
                                    //'feedburner' => 'FeedBurner',
                                    'activecampaign' => 'Active Campaign',
                                    'aweber' => 'Aweber',
                                    'campaignmonitor' => 'Campaign Monitor',
                                    'constantcontact' => 'Constant Contact',
                                    'convertkit' => 'ConvertKit',
                                    'getresponse' => 'Get Response',
                                    //'gravityforms' => 'Gravity Forms',
                                    //'followupemails' => 'Follow-Up Emails',
                                    'icontact' => 'iContact',
                                    'infusionsoft' => 'Infusionsoft',
                                    'madmimi' => 'Mad Mimi',
                                    'mailchimp' => 'MailChimp',
                                    'sendy' => 'Sendy',
                                    //'zapier' => 'Zapier',
                                    //'mailpoet' => 'MailPoet',
                                    //'mymail' => 'MyMail',
                                    //'htmlwebform' => 'HTML Web Form / Shortcode',
                                ) );
    
    natcasesort($emaillist);
    $emaillist = array('database'=>'Database') + $emaillist;
    
    
    
    // Get Page
    global $wpdb;
    $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
    $sql = "SELECT * FROM $tablename WHERE id= %d";
    $safe_sql = $wpdb->prepare($sql,$page_id);
    $page = $wpdb->get_row($safe_sql);

    // Check for base64 encoding of settings
    if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
        $settings = unserialize(base64_decode($page->settings));
    } else {
        $settings = unserialize($page->settings);
    }

    if($settings === false){
        echo '<br><br><strong>There was an issue retrieving your settings. Please open a ticket &amp; copy and paste in this text below.</strong><br><br>';
        echo '<div style="width:500px;white-space: pre-wrap; word-wrap: break-word; ">';
        var_dump($page->settings);
        echo '</div>';
        die();
        
    }

    $blocks = array('description','form','countdown','social_profiles');
    if(!empty($settings->blocks)){
    foreach($block as $v){
        $settings->blocks = seed_wpnb_array_add($v);
    }
    $blocks = $settings->blocks;
    }
    $settings = seed_wpnb_array_add($settings,'blocks',$blocks);

    
    $settings = json_decode(json_encode($settings), FALSE);

    if(empty($settings->schedule_timezone)){
        $settings->schedule_timezone = 'America/New_York';
    }

    if(empty($settings->countdown_timezone)){
        $settings->countdown_timezone = 'America/New_York';
    }

  
     // var_dump($settings);
     // die();
        if($settings !== false){
            ?>

            <div id="seed-wpnb-customizer">
              <?php require_once(SEED_WPNB_PLUGIN_PATH.'customizer/customizer.php'); ?>
            </div>
            <?php
        }
    }

    /**
     * Render the option pages.
     *
     * @since 0.1.0
     */
    function option_page( )
    {

        if(seed_wpnb_cu('none')){return false;}

        $menu_slug = null;
        $page   = $_REQUEST[ 'page' ];
        $layout = $this->get_page_layout();

        ?>
        <div class="wrap seed_wpnb columns-2">

           
            <?php include(SEED_WPNB_PLUGIN_PATH.'admin/header.php') ?>
            <?php $this->plugin_options_tabs(); ?>
            <?php if ( $layout == '2-col' ): ?>
            <div id="poststuff">
                <div id="post-body" class="metabox-holder columns-1">
                    <div id="post-body-content" >
            <?php endif; ?>
                    <?php if(!empty($_GET['tab']))
                            do_action( 'seed_wpnb_render_page', array('tab'=>$_GET['tab']));
                    ?>
                    <?php if(!empty($_GET['tab']) && $_GET['tab'] == 'seed_wpnb_build' ) { 
                    //$token = '6a6c0899-0139-4a25-806e-a780d863a5af';
                    ?>
                        <iframe src="test<?php echo $token ?>" width="100%"  height="500px"></iframe>
                    <?php }else{ ?>
                    
                    
                    <form action="options.php" method="post">

                    <!-- <input name="submit" type="submit" value="<?php _e( 'Save All Changes', 'seedprod-wp-notification-bar-pro' ); ?>" class="button-primary"/> -->
                    <?php if(!empty($_GET['tab']) && $_GET['tab'] != 'seed_wpnb_tab_3') { ?>
                    <!-- <input id="reset" name="reset" type="submit" value="<?php _e( 'Reset Settings', 'seedprod-wp-notification-bar-pro' ); ?>" class="button-secondary"/>     -->
                    <?php } ?>

                            <?php
                            $show_submit = false;
                            foreach ( seed_wpnb_get_options() as $v ) {
                                if ( isset( $v[ 'menu_slug' ] ) ) {
                                    $menu_slug = $v[ 'menu_slug' ];
                                }
                                    if ( $menu_slug == $page ) {
                                        switch ( $v[ 'type' ] ) {
                                            case 'menu';
                                                break;
                                            case 'tab';
                                                $tab = $v;
                                                if ( empty( $default_tab ) )
                                                    $default_tab = $v[ 'id' ];
                                                break;
                                            case 'setting':
                                                $current_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : $default_tab;
                                                if ( $current_tab == $tab[ 'id' ] ) {
                                                    settings_fields( $v[ 'id' ] );
                                                    $show_submit = true;
                                                }

                                                break;
                                            case 'section':
                                                $current_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : $default_tab;
                                                if ( $current_tab == $tab[ 'id' ] or $current_tab === false ) {
                                                    if ( $layout == '2-col' ) {
                                                        echo '<div id="'.$v[ 'id' ].'" class="postbox seedprod-postbox">';
                                                        $icon = $v[ 'icon' ];
                                                        $this->do_settings_sections( $v[ 'id' ],$show_submit,$icon );
                                                        echo '</div>';
                                                    } else {
                                                        do_settings_sections( $v[ 'id' ] );
                                                    }

                                                }
                                                break;

                                        }

                                }
                            }
                        ?>
                    <?php if($show_submit): ?>
                    <p>
                    <!-- <input name="submit" type="submit" value="<?php _e( 'Save All Changes', 'seedprod-wp-notification-bar-pro' ); ?>" class="button-primary"/> -->
                    <!-- <input id="reset" name="reset" type="submit" value="<?php _e( 'Reset Settings', 'seedprod-wp-notification-bar-pro' ); ?>" class="button-secondary"/> -->
                    </p>
                    <?php endif; ?>
                    </form>
                    <?php } ?>
                    <?php //if ( $layout == '2-col' ): ?>
                     <?php if ( 1 == 0 ): ?>
                    </div> <!-- #post-body-content -->

                    <div id="postbox-container-1" class="postbox-container">
                        <div id="side-sortables" class="meta-box-sortables ui-sortable">

                            <div class="postbox rss-postbox" style="background-color: #fcf8e3">
									<div class="handlediv" title="Click to toggle"><br /></div>
									<form action="https://www.getdrip.com/forms/2650489/submissions" method="post" target="_blank" data-drip-embedded-form="2650489">
	  <h3 class="hndle" data-drip-attribute="headline"><span>How to launch a site that&#x27;s successful on Day One</span></h3>
						<div class="inside">


							<p data-drip-attribute="description">There&#x27;s nothing more disappointing than launching a new site and not get enough visitors to support it. Find out how to build an audience before you launch in this free 5-part course.</p>
							<div>
								<label for="fields[email]">Email Address</label><br />
								<input class="regular-text" style="width:100%" type="email" name="fields[email]" value="<?php echo get_option( 'admin_email' ); ?>" />
							</div>

							<div style="margin-top:10px">
								<label for="fields[first_name]">First Name</label><br />
								<input class="regular-text" style="width:100%" type="text" name="fields[first_name]" value="" />
							</div>

						<div style="margin-top:10px">
							<input type="submit" name="submit" value="Subscribe Now" style="background-color:red; border-color:firebrick;" data-drip-attribute="sign-up-button" class="button-primary" />
						</div>


										<!-- <div class="rss-widget">
											<?php
											wp_widget_rss_output(array(
												'url' => 'http://seedprod.com/feed/',
												'title' => 'SeedProd Blog',
												'items' => 3,
												'show_summary' => 0,
												'show_author' => 0,
												'show_date' => 1,
												));
												?>
												<ul>
													<li>&raquo; <a href="http://seedprod.com/subscribe/"><?php _e('Subscribe by Email', 'ultimate-coming-soon-page') ?></a></li>
												</ul>
											</div> -->
										</div>
									</form>


									</div>
                            <!-- <a href="http://www.seedprod.com/plugins/wordpress-coming-soon-pro-plugin/?utm_source=plugin&utm_medium=banner&utm_campaign=coming-soon-pro-in-plugin-banner" target="_blank"><img src="http://static.seedprod.com/ads/coming-soon-pro-sidebar.png" /></a>
                            <br><br> -->
                            <div class="postbox support-postbox" style="background-color:#d9edf7">
                                <div class="handlediv" title="Click to toggle"><br /></div>
                                <h3 class="hndle"><span><?php _e('Plugin Support', 'seedprod-wp-notification-bar-pro') ?></span></h3>
                                <div class="inside">
                                    <div class="support-widget">
                                        <p>
                                            <?php _e('Got a Question, Idea, Problem or Praise?') ?>
                                        </p>
                                        <ul>
                                            <li>&raquo; <a href="https://wordpress.org/support/plugin/coming-soon" target="_blank"><?php _e('Support Request', 'seedprod-wp-notification-bar-pro') ?></a></li>
                                            <li>&raquo; <a href="http://support.seedprod.com/article/83-how-to-clear-wp-super-caches-cache" target="_blank"><?php _e('Common Caching Issues Resolutions', 'seedprod-wp-notification-bar-pro') ?></a></li>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                           
                                <div class="postbox like-postbox" style="background-color:#d9edf7">
                                    <div class="handlediv" title="Click to toggle"><br /></div>
                                    <h3 class="hndle"><span><?php _e('Show Some Love', 'seedprod-wp-notification-bar-pro') ?></span></h3>
                                    <div class="inside">
                                        <div class="like-widget">
                                            <p><?php _e('Like this plugin? Show your support by:', 'seedprod-wp-notification-bar-pro')?></p>
                                            <ul>
                                                <li>&raquo; <a target="_blank" href="http://www.seedprod.com/features/?utm_source=coming-soon-plugin&utm_medium=banner&utm_campaign=coming-soon-link-in-plugin"><?php _e('Buy It', 'seedprod-wp-notification-bar-pro') ?></a></li>

                                                <li>&raquo; <a target="_blank" href="https://wordpress.org/support/view/plugin-reviews/coming-soon?rate=5#postform"><?php _e('Rate It', 'seedprod-wp-notification-bar-pro') ?></a></li>
                                                <li>&raquo; <a target="_blank" href="<?php echo "http://twitter.com/share?url=https%3A%2F%2Fwordpress.org%2Fplugins%2Fultimate-coming-soon-page%2F&text=Check out this awesome %23WordPress Plugin I'm using, Notification Bar and Maintenance Mode by SeedProd"; ?>"><?php _e('Tweet It', 'seedprod-wp-notification-bar-pro') ?></a></li>

                                                <li>&raquo; <a href="https://www.seedprod.com/submit-site/"><?php _e('Submit your site to the Showcase', 'seedprod-wp-notification-bar-pro') ?></a></li>

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            


                                <div class="postbox rss-postbox" style="background-color:#d9edf7">
    											<div class="handlediv" title="Click to toggle"><br /></div>
    											<h3 class="hndle"><span><?php _e('SeedProd Blog', 'ultimate-coming-soon-page') ?></span></h3>
    											<div class="inside">

    												<div class="rss-widget">
    													<?php
    													wp_widget_rss_output(array(
    													'url' => 'http://feeds.feedburner.com/seedprod/',
    													'title' => 'SeedProd Blog',
    													'items' => 3,
    													'show_summary' => 0,
    													'show_author' => 0,
    													'show_date' => 1,
    												));
    												?>
    												<ul>
    													<br>
    												<li>&raquo; <a href="https://www.getdrip.com/forms/9414625/submissions/new"><?php _e('Subscribe by Email', 'ultimate-coming-soon-page') ?></a></li>
    											</ul>
    										</div>
    									</div>
    								</div>

                        </div>
                    </div>
                </div> <!-- #post-body -->


            </div> <!-- #poststuff -->
            <?php endif; ?>
        </div> <!-- .wrap -->

        <!-- JS login to confirm setting resets. -->
        <script>
            jQuery(document).ready(function($) {
                $('#reset').click(function(e){
                    if(!confirm('<?php _e( 'This tabs settings be deleted and reset to the defaults. Are you sure you want to reset?', 'seedprod-wp-notification-bar-pro' ); ?>')){
                        e.preventDefault();
                    }
                });
                if(jQuery(".include_exclude_options:checked").val() == '2'){
                    jQuery("#include_url_pattern").parents('tr').show();
                }else{
                    jQuery("#include_url_pattern").parents('tr').hide();
                }

                if(jQuery(".include_exclude_options:checked").val() == '3'){
                    jQuery("#exclude_url_pattern").parents('tr').show();
                }else{
                    jQuery("#exclude_url_pattern").parents('tr').hide();
                }

                jQuery(".include_exclude_options").click(function() {
                    var val = jQuery(this).val();
                    if(val == '2'){
                        jQuery("#include_url_pattern").parents('tr').fadeIn();
                    }else{
                        jQuery("#include_url_pattern").parents('tr').hide();
                    }

                    if(val == '3'){
                        jQuery("#exclude_url_pattern").parents('tr').fadeIn();
                    }else{
                        jQuery("#exclude_url_pattern").parents('tr').hide();
                    } 
                });
            });
        </script>
        <?php
    }

    /**
     * Create the settings options, sections and fields via the WordPress Settings API
     *
     * This function is attached to the admin_init action hook.
     *
     * @since 0.1.0
     */
    function create_settings( )
    {
        foreach ( seed_wpnb_get_options() as $k => $v ) {

            switch ( $v[ 'type' ] ) {
                case 'menu':
                    $menu_slug = $v[ 'menu_slug' ];

                    break;
                case 'setting':
                    if ( empty( $v[ 'validate_function' ] ) ) {
                        $v[ 'validate_function' ] = array(
                             &$this,
                            'validate_machine'
                        );
                    }
                    register_setting( $v[ 'id' ], $v[ 'id' ], $v[ 'validate_function' ] );
                    $setting_id = $v[ 'id' ];
                    break;
                case 'section':
                    if ( empty( $v[ 'desc_callback' ] ) ) {
                        $v[ 'desc_callback' ] = array(
                             &$this,
                            '__return_empty_string'
                        );
                    } else {
                        $v[ 'desc_callback' ] = $v[ 'desc_callback' ];
                    }
                    add_settings_section( $v[ 'id' ], $v[ 'label' ], $v[ 'desc_callback' ], $v[ 'id' ] );
                    $section_id = $v[ 'id' ];
                    break;
                case 'tab':
                    break;
                default:
                    if ( empty( $v[ 'callback' ] ) ) {
                        $v[ 'callback' ] = array(
                             &$this,
                            'field_machine'
                        );
                    }

                    add_settings_field( $v[ 'id' ], $v[ 'label' ], $v[ 'callback' ], $section_id, $section_id, array(
                         'id' => $v[ 'id' ],
                        'desc' => ( isset( $v[ 'desc' ] ) ? $v[ 'desc' ] : '' ),
                        'setting_id' => $setting_id,
                        'class' => ( isset( $v[ 'class' ] ) ? $v[ 'class' ] : '' ),
                        'type' => $v[ 'type' ],
                        'default_value' => ( isset( $v[ 'default_value' ] ) ? $v[ 'default_value' ] : '' ),
                        'option_values' => ( isset( $v[ 'option_values' ] ) ? $v[ 'option_values' ] : '' )
                    ) );

            }
        }
    }

    /**
     * Create a field based on the field type passed in.
     *
     * @since 0.1.0
     */
    function field_machine( $args )
    {
        extract( $args ); //$id, $desc, $setting_id, $class, $type, $default_value, $option_values

        // Load defaults
        $defaults = array( );
        foreach ( seed_wpnb_get_options() as $k ) {
            switch ( $k[ 'type' ] ) {
                case 'setting':
                case 'section':
                case 'tab':
                    break;
                default:
                    if ( isset( $k[ 'default_value' ] ) ) {
                        $defaults[ $k[ 'id' ] ] = $k[ 'default_value' ];
                    }
            }
        }
        $options = get_option( $setting_id );

        $options = wp_parse_args( $options, $defaults );

        $path = SEED_WPNB_PLUGIN_PATH . 'admin/field-types/' . $type . '.php';
        if ( file_exists( $path ) ) {
            // Show Field
            include( $path );
            // Show description
            if ( !empty( $desc ) ) {
                echo "<small class='description'>{$desc}</small>";
            }
        }

    }

    /**
     * Validates user input before we save it via the Options API. If error add_setting_error
     *
     * @since 0.1.0
     * @param array $input Contains all the values submitted to the POST.
     * @return array $input Contains sanitized values.
     * @todo Figure out best way to validate values.
     */
    function validate_machine( $input )
    {
        if(!isset($_POST['option_page'])){
           return $input; 
        }
        $option_page = $_POST['option_page'];
        foreach ( seed_wpnb_get_options() as $k ) {
            switch ( $k[ 'type' ] ) {
                case 'menu':
                case 'setting':
                    if(isset($k['id']))
                        $setting_id = $k['id'];
                case 'section':
                case 'tab';
                    break;
                default:
                    if ( !empty( $k[ 'validate' ] ) && $setting_id == $option_page ) {
                        $validation_rules = explode( ',', $k[ 'validate' ] );

                        foreach ( $validation_rules as $v ) {
                            $path = SEED_WPNB_PLUGIN_PATH . 'admin/validations/' . $v . '.php';
                            if ( file_exists( $path ) ) {
                                // Defaults Values
                                $is_valid  = true;
                                $error_msg = '';

                                // Test Validation
                                include( $path );

                                // Is it valid?
                                if ( $is_valid === false ) {
                                    add_settings_error( $k[ 'id' ], 'seedprod_error', $error_msg, 'error' );
                                    // Unset invalids
                                    unset( $input[ $k[ 'id' ] ] );
                                }

                            }
                        } //end foreach

                    }
            }
        }

        return $input;
    }

    /**
     * Dummy function to be called by all sections from the Settings API. Define a custom function in the config.
     *
     * @since 0.1.0
     * @return string Empty
     */
    function __return_empty_string( )
    {
        echo '';
    }


    /**
     * SeedProd version of WP's do_settings_sections
     *
     * @since 0.1.0
     */
    function do_settings_sections( $page, $show_submit, $icon )
    {
        global $wp_settings_sections, $wp_settings_fields;

        if ( !isset( $wp_settings_sections ) || !isset( $wp_settings_sections[ $page ] ) )
            return;

        foreach ( (array) $wp_settings_sections[ $page ] as $section ) {
            echo "<h3 class='hndle'><i class='{$icon}'></i> {$section['title']}</h3>\n";
            echo '<div class="inside">';
            call_user_func( $section[ 'callback' ], $section );
            if ( !isset( $wp_settings_fields ) || !isset( $wp_settings_fields[ $page ] ) || !isset( $wp_settings_fields[ $page ][ $section[ 'id' ] ] ) )
                continue;
            echo '<table class="form-table">';
            $this->do_settings_fields( $page, $section[ 'id' ] );
            echo '</table>';
            if($show_submit): ?>
                <p>
                <input name="submit" type="submit" value="<?php _e( 'Save All Changes', 'seedprod-wp-notification-bar-pro' ); ?>" class="button-primary"/>
                </p>
            <?php endif;
            echo '</div>';
        }
    }

    function do_settings_fields($page, $section) {
          global $wp_settings_fields;

          if ( !isset($wp_settings_fields) || !isset($wp_settings_fields[$page]) || !isset($wp_settings_fields[$page][$section]) )
              return;

          foreach ( (array) $wp_settings_fields[$page][$section] as $field ) {
              echo '<tr valign="top">';
              if ( !empty($field['args']['label_for']) )
                  echo '<th scope="row"><label for="' . $field['args']['label_for'] . '">' . $field['title'] . '</label></th>';
              else
                  echo '<th scope="row"><strong>' . $field['title'] . '</strong><!--<br>'.$field['args']['desc'].'--></th>';
              echo '<td>';
              call_user_func($field['callback'], $field['args']);
              echo '</td>';
              echo '</tr>';
          }
      }
    
    /*
     * Sunscriber Actions
     */
    function subscriber_actions(){
        if(isset($_GET['tab']) && $_GET['tab'] == 'seed_wpnb_tab_subscribers'){
    
            if(!empty($_POST['action'])){
                if($_POST['action'] == 'seed_wpnb_export_subscribers'){
                    $this->export_all_subscribers();
                }
            }
        }
    }
    
    /**
     * Subscribe User to Mailing List or return an error.
     */
    function subscribe_callback(){
        //if(check_ajax_referer('seed_wpnb_subscribe_callback')){
        
            // Initialize a global var to store results in
            global $seed_wpnb_post_result;
            global $errors;
            $errors = array();
            
            // Get the page id
            $page_id = '';
            if(!empty($_REQUEST['page_id'])){
                $page_id = $_REQUEST['page_id'];
            }
            $data['page_id'] = $page_id;
            
            //Get page settings
            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
            $sql = "SELECT * FROM $tablename WHERE id= %d";
            $safe_sql = $wpdb->prepare($sql,$page_id);
            $page = $wpdb->get_row($safe_sql);

            if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
                $settings = unserialize(base64_decode($page->settings));
            } else {
                $settings = unserialize($page->settings);
            }

            extract($settings);

            // Get language info
            $lang_id = '';
            if(!empty($_REQUEST['lang'])){
                $lang_id = $_REQUEST['lang'];
            }

            if(!empty($lang_id)){
                $lang_settings_name = 'seed_wpnb_'.$page_id.'_language_'.$lang_id;
                $lang_settings = get_option($lang_settings_name);
                if(!empty($lang_settings)){
                    $lang_settings = maybe_unserialize($lang_settings);
                }
            }
         
            if(!empty($lang_settings['thankyou_msg']) && !empty($lang_id)){
                $ty_content = $lang_settings['thankyou_msg'];     
            }else{
                $ty_content = $settings['thankyou_msg'];    
            }

            if(!empty($lang_settings['txt_stats_referral_url']) && !empty($lang_id)){
                $txt_stats_referral_url = $lang_settings['txt_stats_referral_url'];
            }else{
                //$txt_stats_referral_url = $settings['txt_stats_referral_url'];
            }

            if(!empty($lang_settings['txt_stats_referral_stats']) && !empty($lang_id)){
                $txt_stats_referral_stats = $lang_settings['txt_stats_referral_stats'];
            }else{
                //$txt_stats_referral_stats = $settings['txt_stats_referral_stats'];
            }

            if(!empty($lang_settings['txt_stats_referral_subscribers']) && !empty($lang_id)){
                $txt_stats_referral_subscribers = $lang_settings['txt_stats_referral_subscribers'];
            }else{
                //$txt_stats_referral_subscribers = $settings['txt_stats_referral_subscribers'];
            }

            // Get form info
            // Get form settings
            if(seed_wpnb_cu('fb')){
                $form_settings_name = 'seed_wpnb_'.$page_id.'_form';
                $form_settings = get_option($form_settings_name);
                if(!empty($form_settings)){
                    $form_settings = maybe_unserialize($form_settings);
                }
            }

            // Collect request data
            // Spam check, this will be fined in if spam
            if(!empty($_REQUEST['message'])){
                return false;
            }
    
            // Check field values
            $email = '';
            if(!empty($_REQUEST['email'])){
                $email = sanitize_email($_REQUEST['email']);
            }
            
            $name = '';
            if(!empty($_REQUEST['name'])){
                $name = sanitize_text_field($_REQUEST['name']);
            }

            $optin_confirmation = 0;
            if(!empty($_REQUEST['optin_confirmation'])){
                $optin_confirmation = 1;
            }


            // Sanize random fields
            if(seed_wpnb_cu('fb')){
                foreach($_REQUEST as $k => $v){
                    if(substr( $k, 0, 6 ) === "field_"){
                        $_REQUEST[$k] = sanitize_text_field($v);
                    }
                }
            }


            
            $bypassed_emaillist = apply_filters('seed_wpnb_bypassed_emaillist',array('gravityforms'));

            // Check it we need to validate recaptcha
            if(!in_array($emaillist, $bypassed_emaillist)){
                if(!empty($enable_recaptcha)){
                    $response = wp_remote_post( 'https://www.google.com/recaptcha/api/siteverify', 
                        array('body' => array( 
                            'secret' =>  $recaptcha_secret_key, 
                            'response' => $_REQUEST['g-recaptcha-response'] 
                            )
                        )
                        );

                    if ( is_wp_error( $response ) ) {
                        $seed_wpnb_post_result['status'] = '500';
                        $seed_wpnb_post_result['html'] = $error_message;
                    } else {
                        $body = json_decode(wp_remote_retrieve_body($response));
                    }

                    if($body->success === false){
                         $seed_wpnb_post_result['status'] = '400';
                         $seed_wpnb_post_result['msg'] = 'Invalid Recapcha';
                         $seed_wpnb_post_result['msg_class'] = 'alert-danger';
                         $errors[] = $seed_wpnb_post_result['msg'];
        
                         $emaillist = '';
                    }
                }
            }

    
        // Check it we need to validate email
            if(!in_array($emaillist, $bypassed_emaillist)){
                if(is_email($email) != $email || empty($email)){
                     $seed_wpnb_post_result['status'] = '400';
                     if(!empty($lang_settings['txt_invalid_email_msg']) && !empty($lang_id)){
                        $seed_wpnb_post_result['msg'] = $lang_settings['txt_invalid_email_msg'];
                     }else{
                        $seed_wpnb_post_result['msg'] = $txt_invalid_email_msg;
                     }
                     $seed_wpnb_post_result['msg_class'] = 'alert-danger';
                     $errors[] = $seed_wpnb_post_result['msg'];
    
                     $emaillist = '';
                }
            }
            
            // Check it we need to validate name
            if(!in_array($emaillist, $bypassed_emaillist)){
                if(!empty($display_name)){
                    if(!empty($require_name)){
                        if(empty($name)){
                             $seed_wpnb_post_result['status'] = '400';
                             if(!empty($lang_settings['txt_invalid_name_msg']) && !empty($lang_id)){
                                $seed_wpnb_post_result['msg'] = $lang_settings['txt_invalid_name_msg'];
                             }else{
                                $seed_wpnb_post_result['msg'] = $txt_invalid_name_msg;
                             }
                             $seed_wpnb_post_result['msg_class'] = 'alert-danger';
                             $errors[] = $seed_wpnb_post_result['msg'];
                             
        
                             $emaillist = '';
                        }
                    }
                }

                if(!empty($display_optin_confirm)){
                    if(empty($optin_confirmation)){
                            $seed_wpnb_post_result['status'] = '400';
                            if(!empty($lang_settings['txt_optin_confirmation_required']) && !empty($lang_id)){
                            $seed_wpnb_post_result['msg'] = $lang_settings['txt_optin_confirmation_required'];
                            }else{
                            $seed_wpnb_post_result['msg'] = $txt_optin_confirmation_required;
                            }
                            $seed_wpnb_post_result['msg_class'] = 'alert-danger';
                            $errors[] = $seed_wpnb_post_result['msg'];
                            
    
                            $emaillist = '';
                    }
                }

                //Check custom fields for required
                if(!empty($form_settings) && seed_wpnb_cu('fb')){
                foreach($form_settings as $k => $v){
                    if(is_array($v)){
                        if(substr( $k, 0, 6 ) === "field_" && $k != 'field_name'){
                            if(!empty($v['required'])){
                                if(empty($_REQUEST[$k])){
                                    $seed_wpnb_post_result['status'] = '400';
                                     // if(!empty($lang_settings['txt_invalid_name_msg']) && !empty($lang_id)){
                                     //    $seed_wpnb_post_result['msg'] = $lang_settings['txt_invalid_name_msg'];
                                     // }else{
                                        $seed_wpnb_post_result['msg'] = $v['name'].' Required';
                                     //}
                                     $seed_wpnb_post_result['msg_class'] = 'alert-danger';
                                     $errors[] = $seed_wpnb_post_result['msg'];
                                     
                
                                     $emaillist = '';
                                }
                            }
                        }
                    }
                }
                }
            }

           
            // Do email list action
            if(!empty($emaillist)){
                $data['settings'] = $settings;
                // Get settings
                $mod = '';
                if($emaillist == 'mailchimp'){
                    $e_settings_name = 'seed_wpnb_'.$page_id.'_'.$emaillist;
                    $e_settings = get_option($e_settings_name);
                    if(!empty($e_settings)){
                        $e_settings = maybe_unserialize($e_settings);
                    }
                    if(empty($e_settings['mailchimp_api_key']) || (!empty($e_settings['api_version']) && $e_settings['api_version'] == '3')){
                        // Use V3
                        $mod = '_v3';
                    }
                }
                do_action('seed_wpnb_emaillist_'.$emaillist.$mod,$data);
            }
        //}



        
        $html = '';


        if(isset($GLOBALS['wp_embed'])){
            $ty_content = $GLOBALS['wp_embed']->autoembed($ty_content);
        }
        $ty_content = do_shortcode(shortcode_unautop(wpautop(convert_chars(wptexturize($ty_content)))));
        
        // Return HTML
        if('200' == $seed_wpnb_post_result['status']){
             // New Subscriber
            $status = '200';
            $hide = '';
            if($settings['hide_bar_after_sign_up']){
                $hide = '<script>setTimeout(function(){jQuery( "#wpnbio-close" ).trigger("click"); }, 3000);</script>';
            }
            $html = $ty_content.$settings['conversion_scripts'].$hide;
            if(!empty($settings['enable_reflink'])){
                $html .= "<br><br>".$txt_stats_referral_url.'<br>'.seed_wpnb_ref_link();
            }
        }elseif('409' == $seed_wpnb_post_result['status']){
             // Already Subscribed
            $status = '409';



            $html = $settings['txt_already_subscribed_msg'];
            if(!empty($settings['enable_reflink'])){
                 // Already Subscribed send Referaral Info
                $html .= "<br><br>".$txt_stats_referral_url.'<br>'.seed_wpnb_ref_link();
                $html .= '<br><br>'.$txt_stats_referral_stats.'<br>'.$txt_stats_referral_subscribers.': '.$seed_wpnb_post_result['subscribers'];
                $html = $html;
            }
        }elseif('400' == $seed_wpnb_post_result['status']){
            // Validation Error
            $status = '400';
            $html ='<div id="wpnbio-alert" class="alert '.$seed_wpnb_post_result['msg_class'].'"><ul>';
            foreach($errors as $e){
                $html .=  $e.' ';
            }
            $html .= '</ul></div>';
        }elseif('500' == $seed_wpnb_post_result['status']){
            // API Error
            $status = '500';
            $html = $seed_wpnb_post_result['html'];
        }
        
        if($status != '500'){
            $html = '<div id="wpnbio-thankyoumsg" class="wpnbio-section">'.$html.'</div>';
        }
        
        $content = '';
        ob_start();
        //include(SEED_WPNB_PLUGIN_PATH.'template/show_share_buttons_ty.php');
        $content = ob_get_clean();
        header('Content-Type: text/javascript; charset=utf8');
        // Return jsonp results
        $html = $html.$content;

        $response = array(
            'status' => $status,
            'html' => $html
        );
        echo sanitize_text_field($_GET['callback']) . '(' . json_encode($response) . ')';
        exit();
    }
    
    /*
     * Export Subscribers
     */
    function export_all_subscribers(){
        ob_get_clean();
        global $wpdb;
        $csv_output = '';
        $csv_output .= "Bar,Email,Fname,Lname,IP,Created";
        $csv_output .= "\n";
        $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
        $sql = "SELECT * FROM " . $tablename;
        $results = $wpdb->get_results($sql);
        foreach ($results as $result) {
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
            $sql = "SELECT name FROM $tablename WHERE id = %d";
            $safe_sql = $wpdb->prepare($sql,$result->page_id);
            $pp = $wpdb->get_var($safe_sql);
            $page = $pp;

            $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
            $sql = "SELECT email FROM $tablename WHERE id = %d";
            $safe_sql = $wpdb->prepare($sql,$result->referrer);
            $pr = $wpdb->get_var($safe_sql);
            $referrer = $pr;

            // Get meta
            $print_meta = '';
            if(seed_wpnb_cu('fb')){
                $form_settings_name = 'seed_wpnb_'.$result->page_id.'_form';
                $form_settings = get_option($form_settings_name);
                if(!empty($form_settings)){
                    $form_settings = maybe_unserialize($form_settings);
                }
                $meta = null;
                
                if(!empty($result->meta)){
                    $meta = maybe_unserialize($result->meta);
                    foreach($meta as $k => $v){
                        if(substr( $k, 0, 6 ) === "field_"){
                            $print_meta .= $form_settings[$k]['label'].":".$v.',';
                        }
                    }
                }
            }

            
            if(!empty($result->location)){
                $location = json_decode($result->location,true);
                $city = $location['city'];
                $country = $location['country_name'];
            }else{
                $city = '';
                $country = '';
            }
           $csv_output .= $page .",".$result->email ."," . $result->fname . ",". $result->lname . "," . $result->ip . "," . $result->created ."\n";
        }

        $filename = "subscribers_".date("Y-m-d_H-i",time());
        header("Content-type: text/plain");
        header("Content-disposition: attachment; filename=".$filename.".csv");
        print $csv_output;
        die();
    } 

    /*
     * Delete Pages
     */
    function delete_all_pages(){
        if (current_user_can( 'delete_users' )) {
            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
            $sql = "DELETE FROM " . $tablename . " WHERE type = 'lp'";
            $result = $wpdb->query($sql);
            if($result){
                return true;
            }
        }
    } 

    /*
     * Delete Selected Pages
     */
    function delete_selected_pages($ids){
        if (current_user_can( 'list_users' )) {
            if(is_array($ids) && !empty($ids)){
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
                $sql = "DELETE FROM " . $tablename . " WHERE id IN ( ".implode(",", $ids)." )";
                $result = $wpdb->query($sql);
                if($result){
                    return true;
                }
            }
        }
    } 
      
    /*
     * Delete Subscribers
     */
    function delete_all_subscribers(){
        if (current_user_can( 'delete_users' )) {
            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
            $sql = "TRUNCATE " . $tablename;
            $result = $wpdb->query($sql);
            if($result){
                return true;
            }
        }
    } 

    /*
     * Delete Selected Subscribers
     */
    function delete_selected_subscribers($ids){
        if (current_user_can( 'list_users' )) {
            if(is_array($ids) && !empty($ids)){
                global $wpdb;
                $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
                $sql = "DELETE FROM " . $tablename . " WHERE id IN ( ".implode(",", $ids)." )";
                $result = $wpdb->query($sql);
                if($result){
                    return true;
                }
            }
        }
    } 
    
    /*
	 * Display Subscribers
	 */
	 function display_subscribers($args){
        if(seed_wpnb_cu('none')){return false;}
        //Display if we are on the subscribers tab
		if($args['tab'] == 'seed_wpnb_tab_subscribers'){
    
            if(!empty($_POST['action'])){
                //$nonce = $_POST['_wpnonce'];
                //var_dump(wp_verify_nonce($nonce, 'buljk-toplevel_page_seed_wpnb'));
                if($_POST['action'] == 'seed_wpnb_delete_subscribers'){
                    if($this->delete_all_subscribers()){
                        echo '
                        <div id="setting-error-seedprod_error" class="error settings-error below-h2"> 
                        <p><strong>'.__('All subscribers deleted.','seedprod').'</strong></p></div>';
                    }
                }
                if($_POST['action'] == 'seed_wpnb_delete_selected_subscribers'){
                    if($this->delete_selected_subscribers($_POST['subscriber'])){
                        echo '
                        <div id="setting-error-seedprod_error" class="error settings-error below-h2"> 
                        <p><strong>'.__('Selected subscribers deleted.','seedprod').'</strong></p></div>';
                    }
                }
            }
            // Get all page ids
            $page_id = '';
            if(isset($_GET['page_id'])){
              $page_id = $_GET['page_id'];  
            }

            global $wpdb;
            $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
            $sql = "SELECT id,name FROM $tablename";
            $pages = $wpdb->get_results($sql);
            $options = array('<option value="">All Bars</option>');
            foreach($pages as $p){
                $selected = '';
                if($page_id == $p->id){
                    $selected = 'selected';
                }
                $options[] = "<option value='$p->id' $selected>$p->name</option>";
            }

            // Get page settings
            if(!empty($page_id)){
                $sql = "SELECT * FROM $tablename WHERE id = %d";
                $safe_sql = $wpdb->prepare($sql,$page_id);
                $page_settings = $wpdb->get_row($safe_sql);
            }
            



            
            // Render Subscriber

            $seed_wpnb_subscribers = new SEED_WPNB_SUBSCRIBERS();
            $seed_wpnb_subscribers->prepare_items();
            //echo '<strong>Page</strong> <select id="seed_wpnb_page_id">'.implode($options).'</select>';
            ?>
            <script>
            jQuery( document ).ready(function($) {
                jQuery('#seed_wpnb_page_id').change(function() {
                    id = $(this).val();
                    location.href = '<?php echo admin_url() ?>options-general.php?page=seed_wpnb&tab=seed_wpnb_tab_subscribers&page_id='+id;
                });
            });
            </script>


            <?php

            if(!empty($page_settings->mailprovider)){
               echo '<p>Emails are being collected to: <strong>'.ucfirst($page_settings->mailprovider).'</strong></p>'; 
            }
            

            echo '<form id="seed_wpnb_search"" method="post">';
            $seed_wpnb_subscribers->search_box('Search Emails', 'email'); 
            echo '</form>';
            echo '<form id="seed_wpnb_bulk_actions" method="post">';
            $seed_wpnb_subscribers->display();
            wp_nonce_field('seed_wpnb_subscribers');
            echo '</form>';

        ?>
        <script>
        jQuery(document).ready(function($){
            $(".bottom > .actions").hide();
            $("#doaction").click(function(event) {
                event.preventDefault();
                var action = $('select[name="action"]').val();
                if(action != '-1'){
                    if(action == 'delete'){
                        if(confirm(seed_wpnb_msgs.delete_confirm)){
                            $("#seed_wpnb_bulk_actions").submit();
                        }
                    }else{
                        $("#seed_wpnb_bulk_actions").submit();
                    }
                }
            });
        });
        </script>

        <?php

		}
	}
    
    
    /*
	 * Display Pages
	 */
	function display_pages($args){
        //Display if we are on the subscribers tab
		if($args['tab'] == 'seed_wpnb_tab_pages'){


echo '<h2>Add new Notification Bar</h2>';
echo "<input autocomplete='off' id='page_path' class='regular-text' type='text' placeholder='Name' />";
echo "<button id='seed_wpnb_page_create' type='button' class='button-primary'>".__('Create Bar','seedprod-wp-notification-bar-pro')."</button><br>";
echo "<div id='seed_wpnb_page_msg'></div>";
echo '<small class="description">Enter a Name for the Bar.';
?>
<script type='text/javascript'>
jQuery(document).ready(function($) {
    $('#seed_wpnb_page_create').click(function() {
      $('#seed_wpnb_page_create').prop("disabled", true);
      $('#seed_wpnb_check_page_msg').hide();
    	name= $('#page_path').val();
    	if(name!= ''){
            location.href="<?php echo admin_url() ?>options-general.php?page=seed_wpnb_themes&page_id=-1&type=lp&name="+name;
		}else{
      $('#seed_wpnb_page_msg').show();
			$('#seed_wpnb_page_create').prop("disabled", false);
		}

    }); 
});
</script>
<br><br>
<hr>
<?php
    echo '<h2>Notification Bars</h2>';
            if(!empty($_POST['action'])){
                //$nonce = $_POST['_wpnonce'];
                //var_dump(wp_verify_nonce($nonce, 'buljk-toplevel_page_seed_wpnb'));
                if($_POST['action'] == 'seed_wpnb_delete_pages'){
                    if($this->delete_all_pages()){
                        echo '
                        <div id="setting-error-seedprod_error" class="error settings-error below-h2"> 
                        <p><strong>'.__('All pages deleted.','seedprod-wp-notification-bar-pro').'</strong></p></div>';
                    }
                }
                if($_POST['action'] == 'seed_wpnb_delete_selected_pages'){
                    if($this->delete_selected_pages($_POST['subscriber'])){
                        echo '
                        <div id="setting-error-seedprod_error" class="error settings-error below-h2"> 
                        <p><strong>'.__('Selected bars deleted.','seedprod-wp-notification-bar-pro').'</strong></p></div>';
                    }
                }
            }


            
            // Render Subscriber
            $seed_wpnb_pages = new SEED_WPNB_PAGES();
            $seed_wpnb_pages->prepare_items();
            echo '<form id="seed_wpnb_search"" method="post">';
            $seed_wpnb_pages->search_box('Search Bars', 'email'); 
            echo '</form>';
            echo '<form id="seed_wpnb_bulk_actions" method="post">';
            $seed_wpnb_pages->display();
            wp_nonce_field('seed_wpnb_subscribers');
            echo '</form>';

        ?>
        <script>
        jQuery(document).ready(function($){
            $(".bottom > .actions").hide();
            $("#doaction").click(function(event) {
                event.preventDefault();
                var action = $('select[name="action"]').val();
                if(action != '-1'){
                    if(action == 'delete'){
                        if(confirm(seed_wpnb_msgs.delete_confirm)){
                            $("#seed_wpnb_bulk_actions").submit();
                        }
                    }else{
                        $("#seed_wpnb_bulk_actions").submit();
                    }
                }
            });
        });
        </script>

        <?php

		}
	}


}

// Display Subscribers Class
if( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class SEED_WPNB_PAGES extends WP_List_Table {
    function get_data($current_page,$per_page){
        // Get records
        global $wpdb;
        $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;

        $sql = "SELECT * FROM $tablename";

        if(!empty($_POST['s'])){
            $sql .= ' WHERE name LIKE "%'. esc_sql($_POST['s']) .'%"';
        }

        if ( ! empty( $_GET['orderby'] ) ) {
            $sql .= ' ORDER BY ' . esc_sql( $_GET['orderby'] );
            $sql .= ! empty( $_GET['order'] ) ? ' ' . esc_sql( $_GET['order'] ) : ' ASC';
        }

        $sql .= " LIMIT $per_page";
        $sql .= ' OFFSET ' . ( $current_page - 1 ) * $per_page;

        $results = $wpdb->get_results($sql);
        $data = array();
        foreach($results as $v){
            // Path
            $path = $v->path;
            $name = $v->name;
            
 
            // Format Date
            $date = date(get_option('date_format').' '.get_option('time_format'), strtotime($v->created));
            $created  = $date;

            // Get Settings
            if (base64_encode(base64_decode($v->settings, true)) === $v->settings) {
                $settings = unserialize(base64_decode($v->settings));
            } else {
                $settings = unserialize($v->settings);
            }

            $enable_bar = 'No';
            if(!empty($settings['enable_bar']) && $settings['enable_bar'] == '1' ){
                $enable_bar = 'Yes';
            }elseif(!empty($settings['enable_bar']) && $settings['enable_bar'] == '2' ){
            if(!empty($settings['scheduled_start_date'])){
                $start_date = date(get_option('date_format').' '.get_option('time_format'), strtotime($settings['scheduled_start_date']));
                $enable_bar = 'Starts on: '. $start_date;
            }
            if(!empty($settings['scheduled_end_date'])){
                $end_date = date(get_option('date_format').' '.get_option('time_format'), strtotime($settings['scheduled_end_date']));
                if(!empty($settings['scheduled_start_date'])){
                    $enable_bar .= '<br>';
                    $enable_bar .= 'Ends on: '. $end_date;
                }else{
                    $enable_bar = 'Ends on: '. $end_date;
                }

                
            }
            }


            // Load Data
            $data[] = array(
                'ID' => $v->id,
                'name' => esc_html($name),
                'enabled' => $enable_bar  ,
                'path' => '<a href="'.home_url().'/'.$path.'" target="_blank">'.home_url().'/'.$path.'</a>',
                'created' => $created,
            );
        }
        return $data;
    }

    function get_data_total(){
        global $wpdb;

        $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;

        $sql = "SELECT count(id) FROM $tablename";

        if(!empty($_POST['s'])){
            $sql .= ' WHERE name LIKE "%'. esc_sql($_POST['s']) .'%"';
        }

        $results = $wpdb->get_var($sql);
        return $results;
    }

    function get_sortable_columns() {
      $sortable_columns = array(
        'created'   => array('created',false)
      );
      return $sortable_columns;
    }



    function get_columns(){
      $columns = array(
        'cb'        => '<input type="checkbox" />',
        'name'    => __('Name','seedprod'),
        'enabled'    => __('Enabled','seedprod'),
        'created'      => __('Created','seedprod'),
      );
      return $columns;
    }
    function prepare_items() {
      $columns = $this->get_columns();
      $hidden = array();
      $sortable = $this->get_sortable_columns();
      $this->_column_headers = array($columns, $hidden, $sortable);
      $per_page = 10;
      $current_page = $this->get_pagenum();
      $total_items = $this->get_data_total();
      $this->set_pagination_args( array(
        'total_items' => $total_items,
        'per_page'    => $per_page
      ) );
      $data = $this->get_data($current_page,$per_page);
      //usort( $data, array( &$this, 'usort_reorder' ) );
      $this->items = $data;
    }

    function column_default( $item, $column_name ) {
      switch( $column_name ) {
        case 'name':
        case 'enabled':
        case 'created':
          return $item[ $column_name ];
        default:
          return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
        }
    }

    function get_bulk_actions() {
      $actions = array(
        //'seed_wpnb_delete_pages'    => __('Delete All','seedprod'),
        'seed_wpnb_delete_selected_pages'    => __('Delete Selected','seedprod'),
      );
      return $actions;
    }

    function column_cb($item) {
        return sprintf(
            '<input type="checkbox" name="subscriber[]" value="%s" />', $item['ID']
        );
    }
    

    function column_name($item) {
      $actions = array(
                'edit'      => sprintf('<a href="options-general.php?page=seed_wpnb_customizer&seed_wpnb_customize=%s">Edit</a>',$item['ID']),
            );
      return sprintf('%1$s %2$s', $item['name'], $this->row_actions($actions, true) );
    }
}


class SEED_WPNB_SUBSCRIBERS extends WP_List_Table {
    function get_data($current_page,$per_page){
        // Get records
        global $wpdb;
        $l1 = ($current_page-1)* $per_page;
        $l2 = $per_page;
        $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
        $email = '%'.$_POST['s'].'%';
        $page_id = '';

        if(isset($_GET['page_id']) && $_GET['page_id'] != '' ){
            $page_id = $_GET['page_id'];
            $q = "WHERE email LIKE %s AND page_id = %d ";
        }else{
            $q = "WHERE email LIKE %s ";
        }

        $sql = "SELECT * FROM $tablename $q LIMIT $l1,$l2";
        $safe_sql = $wpdb->prepare($sql,$email,$page_id);
        $results = $wpdb->get_results($safe_sql);
        //var_dump($safe_sql);
        $data = array();
        foreach($results as $v){
            // Sep
            $sep = '';
            if($v->fname != '' || $v->lname != ''){
                $sep = '<br>';
            }
            // Format Date
            $date = date(get_option('date_format').' '.get_option('time_format'), strtotime($v->created));

            // Get Gravatar
            $gravatar = '<img src="http://www.gravatar.com/avatar/'.md5($v->email) .'?s=36" alt="Gravatar" style="float:left;padding:2px;backgroun-color:#fff;border:1px solid #ccc;margin-right:8px">';

            // Format email
            $email = "<a href='mailto:{$v->email}'>{$v->email}</a>";

            $ref = $v->id+1000;
            if($v->ref_url){
                $referrer_url = $v->ref_url;
            }else{
                $referrer_url = home_url() . '?ref='.base_convert($ref, 10, 36);
            }

            // Subscriber
            $subscriber = $gravatar.$v->fname.' '.$v->lname.$sep.$email;

            // Influence
            $influence = $v->conversions. ' of '. $v->clicks. ' referrals have subscribed to your list';

            $conversions = $v->conversions;
            if(!empty($v->conversions)){
                $conversion_rate = round(($v->conversions/$v->clicks) * 100).'%';
            }else{
                $conversion_rate = '0%';
            }
            $clicks = $v->clicks;


            // Get meta
            $print_meta = '';
            if(seed_wpnb_cu('fb')){
                $form_settings_name = 'seed_wpnb_'.$v->id.'_form';
                $form_settings = get_option($form_settings_name);
                if(!empty($form_settings)){
                    $form_settings = maybe_unserialize($form_settings);
                }
                $meta = null;
                
                if(!empty($v->meta)){
                    $meta = maybe_unserialize($v->meta);
                    foreach($meta as $k1 => $v1){
                        if(substr( $k1, 0, 6 ) === "field_"){
                            $print_meta .= $form_settings[$k1]['label'].":".$v1.PHP_EOL;
                        }
                    }
                }
            }      
            // var_dump($print_meta);
            // die();


            
            // Insights
            $insights = '';
            // $insights .= $v->insights;
            // var_export(json_decode($v->insights,true));
            if(!empty($v->location)){
                $location = json_decode($v->location,true);
                $insights .= 'Subscribed from: '.$location['city'].', '.$location['country_name'].'<br>';
            }

            $insights .= __('Subscribed on: ','seedprod').$date;
            $created  = $date;

            $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
            $sql = "SELECT email FROM $tablename WHERE id = %d";
            $safe_sql = $wpdb->prepare($sql,$v->referrer);
            $results = $wpdb->get_results($safe_sql);

            $referrer = null;
            if(!empty($results[0]->email))
            $referrer = $results[0]->email;

            // Load Data
            $data[] = array(
                'ID' => $v->id,
                'subscriber' => $subscriber,
                'clicks' => $clicks,
                'conversions' => $conversions,
                'conversion_rate' => $conversion_rate,
                'created' => $created,
                'referrer' => $referrer,
                'meta' => $print_meta,
                );
        }
        return $data;
    }

    function get_data_total(){
        global $wpdb;
        if(empty($_POST['s']))
            $_POST['s'] = '';
        $page_id = '';
        if(isset($_GET['page_id']) && $_GET['page_id'] != '' ){
            $page_id = $_GET['page_id'];
            $q = "WHERE email LIKE %s AND page_id = %d ";
        }else{
            $q = "WHERE email LIKE %s ";
        }
        $tablename = $wpdb->prefix . SEED_WPNB_SUBSCRIBERS_TABLENAME;
        $email = '%'.$_POST['s'].'%';
        $sql = "SELECT count(id) FROM $tablename $q";
        $safe_sql = $wpdb->prepare($sql,$email,$page_id);
        $results = $wpdb->get_var($safe_sql);
        return $results;
    }

    function get_sortable_columns() {
      $sortable_columns = array(
        'clicks'  => array('clicks',false),
        'conversions' => array('conversions',false),
        'conversion_rate'   => array('conversion_rate',false),
        'created'   => array('created',false)
      );
      return $sortable_columns;
    }

    function usort_reorder( $a, $b ) {
      // If no sort, default to created
      $orderby = ( ! empty( $_GET['orderby'] ) ) ? $_GET['orderby'] : 'created';
      // If no order, default to asc
      $order = ( ! empty($_GET['order'] ) ) ? $_GET['order'] : 'asc';
      // Determine sort order
      $result = strcmp( $a[$orderby], $b[$orderby] );
      // Send final sort direction to usort
      return ( $order === 'asc' ) ? $result : -$result;
    }

    function get_columns(){
      $columns = array(
        'cb'        => '<input type="checkbox" />',
        'subscriber' => __('Subscribers','seedprod'),
        // 'clicks'    => __('Clicks','seedprod'),
        // 'conversions'    => __('# People Signed Up','seedprod'),
        // 'conversion_rate'    => __('Conversion Rate','seedprod'),
        'created'      => __('Created','seedprod'),
        // 'referrer'      => __('Referrer','seedprod'),
        // 'meta'      => __('Meta','seedprod'),
      );
      return $columns;
    }
    function prepare_items() {
      $columns = $this->get_columns();
      $hidden = array();
      $sortable = $this->get_sortable_columns();
      $this->_column_headers = array($columns, $hidden, $sortable);
      $per_page = 10;
      $current_page = $this->get_pagenum();
      $total_items = $this->get_data_total();
      $this->set_pagination_args( array(
        'total_items' => $total_items,
        'per_page'    => $per_page
      ) );
      $data = $this->get_data($current_page,$per_page);
      //usort( $data, array( &$this, 'usort_reorder' ) );
      $this->items = $data;
    }

    function column_default( $item, $column_name ) {
      switch( $column_name ) {
        case 'subscriber':
        case 'clicks':
        case 'conversions':
        case 'conversion_rate':
        case 'created':
        case 'referrer':
        case 'meta':
          return $item[ $column_name ];
        default:
          return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
        }
    }

    function get_bulk_actions() {
      $actions = array(
        'seed_wpnb_export_subscribers'    => __('Export All','seedprod'),
        //'seed_wpnb_delete_subscribers'    => __('Delete All','seedprod'),
        'seed_wpnb_delete_selected_subscribers'    => __('Delete Selected','seedprod'),
      );
      return $actions;
    }

    function column_cb($item) {
        return sprintf(
            '<input type="checkbox" name="subscriber[]" value="%s" />', $item['ID']
        );
    }

    function column_subscriber($item) {
      $actions = array(
                //'profile'      => sprintf('<a href="?page=%s&action=%s&book=%s">Profile</a>',$_REQUEST['page'],'profile',$item['ID']),
            );
      return sprintf('%1$s %2$s', $item['subscriber'], $this->row_actions($actions) );
    }
}

