<?php

/**
* Blogname shortcode
*/
function seed_clp_blogname( $atts ){
    return get_bloginfo('name');
}
add_shortcode( 'clp_blogname', 'seed_clp_blogname' );

/**
* Add to array if value does not exist
*/
function seed_clp_array_add($arr, $key, $value){
    if (!array_key_exists($key, $arr)) {

        $arr[$key] = $value;
    }
    return $arr;
}

/**
* Page default settings
*/
function seed_clp_get_page_default_settings(){
    $settings = array();
    // Default Block
    $blocks = array('logo','headline','description','form','progress_bar','countdown','social_profiles','share_buttons','column');
    if(!empty($settings->blocks)){
    foreach($block as $v){
        $settings->blocks = seed_clp_array_add($v);
    }
    $blocks = $settings->blocks;
    }

    //var_dump($settings);
    //die();

    $fields = array('name');

    $settings = seed_clp_array_add($settings,'disabled_fields', '');
    $settings = seed_clp_array_add($settings,'typekit_id', '');
    $settings = seed_clp_array_add($settings,'publish_method', '');
    $settings = seed_clp_array_add($settings,'header_scripts', '');
    $settings = seed_clp_array_add($settings,'footer_scripts', '');
    $settings = seed_clp_array_add($settings,'conversion_scripts', '');
    $settings = seed_clp_array_add($settings,'theme_css', '');
    $settings = seed_clp_array_add($settings,'custom_css', '');
    $settings = seed_clp_array_add($settings,'footer_affiliate_link', '');
    $settings = seed_clp_array_add($settings,'credit_type', '');
    $settings = seed_clp_array_add($settings,'progress_bar_method', '');
    $settings = seed_clp_array_add($settings,'button_subset', '');
    $settings = seed_clp_array_add($settings,'show_sharebutton_on', 'thank-you');
    $settings = seed_clp_array_add($settings,'fields',$fields);
    $settings = seed_clp_array_add($settings,'blocks',$blocks);
    $settings = seed_clp_array_add($settings,'logo','');
    $settings = seed_clp_array_add($settings,'logo_link','');
    $settings = seed_clp_array_add($settings,'logo_alt_txt','');
    $settings = seed_clp_array_add($settings,'headline','');
    $settings = seed_clp_array_add($settings,'description',"");
    $settings = seed_clp_array_add($settings,'description_below',"");
    $settings = seed_clp_array_add($settings,'error_msg_bg_color',"rgba(255,255,255,0)");
    $settings = seed_clp_array_add($settings,'emaillist','database');
    $settings = seed_clp_array_add($settings,'privacy_policy_link_text','We promise to never spam you.');
    $settings = seed_clp_array_add($settings,'thankyou_msg','Thank You!');
    $settings = seed_clp_array_add($settings,'tweet_text','');
    $settings = seed_clp_array_add($settings,'facebook_thumbnail','');
    $settings = seed_clp_array_add($settings,'pinterest_thumbnail','');
    $settings = seed_clp_array_add($settings,'progress_bar_start_date','');
    $settings = seed_clp_array_add($settings,'progress_bar_end_date','');
    $settings = seed_clp_array_add($settings,'progressbar_percentage','0');
    $settings = seed_clp_array_add($settings,'countdown_date','');
    $settings = seed_clp_array_add($settings,'countdown_timezone','US/Eastern');
    $settings = seed_clp_array_add($settings,'countdown_format','dHMS');
    $settings = seed_clp_array_add($settings,'social_profiles_size','');
    $settings = seed_clp_array_add($settings,'favicon','');
    $settings = seed_clp_array_add($settings,'seo_title','');
    $settings = seed_clp_array_add($settings,'seo_description','');
    $settings = seed_clp_array_add($settings,'ga_analytics','');
    $settings = seed_clp_array_add($settings,'footer_credit_text','');
    $settings = seed_clp_array_add($settings,'footer_credit_img','');
    $settings = seed_clp_array_add($settings,'footer_credit_link','');
    $settings = seed_clp_array_add($settings,'background_color','#ffffff');
    $settings = seed_clp_array_add($settings,'background_size','cover');
    $settings = seed_clp_array_add($settings,'background_repeat','no-repeat');
    $settings = seed_clp_array_add($settings,'background_position','fixed');
    $settings = seed_clp_array_add($settings,'background_attachment','center top');
    $settings = seed_clp_array_add($settings,'background_image','');
    $settings = seed_clp_array_add($settings,'bg_slideshow_slide_speed','3');
    $settings = seed_clp_array_add($settings,'bg_slideshow_slide_transition','1');
    $settings = seed_clp_array_add($settings,'bg_video_url','');
    $settings = seed_clp_array_add($settings,'share_buttons_twitter','');
    $settings = seed_clp_array_add($settings,'share_buttons_facebook','');
    $settings = seed_clp_array_add($settings,'share_buttons_facebook_send','');
    $settings = seed_clp_array_add($settings,'share_buttons_google','');
    $settings = seed_clp_array_add($settings,'share_buttons_linkedin','');
    $settings = seed_clp_array_add($settings,'share_buttons_pinit','');
    $settings = seed_clp_array_add($settings,'share_buttons_tumblr','');
    $settings = seed_clp_array_add($settings,'show_sharebutton_on_front','');
    $settings = seed_clp_array_add($settings,'enable_form','1');
    $settings = seed_clp_array_add($settings,'enable_fitvid','1');
    $settings = seed_clp_array_add($settings,'bg_slideshow','');
    $settings = seed_clp_array_add($settings,'bg_slideshow_randomize','');
    $settings = seed_clp_array_add($settings,'bg_video','');
    $settings = seed_clp_array_add($settings,'bg_video_loop','');
    $settings = seed_clp_array_add($settings,'container_flat','1');
    $settings = seed_clp_array_add($settings,'progressbar_effect','');
    $settings = seed_clp_array_add($settings,'headline_subset','');
    $settings = seed_clp_array_add($settings,'theme','0');
    $settings = seed_clp_array_add($settings,'social_profiles_blank','1');
    $settings = seed_clp_array_add($settings,'headline_font','Open Sans');
    $settings = seed_clp_array_add($settings,'headline_color','#333333');
    $settings = seed_clp_array_add($settings,'headline_size','32');
    $settings = seed_clp_array_add($settings,'headline_weight','400');
    $settings = seed_clp_array_add($settings,'headline_line_height','1');
    $settings = seed_clp_array_add($settings,'text_font','Open Sans');
    $settings = seed_clp_array_add($settings,'text_color','#555555');
    $settings = seed_clp_array_add($settings,'text_size','16');
    $settings = seed_clp_array_add($settings,'text_weight','400');
    $settings = seed_clp_array_add($settings,'text_line_height','1.5');
    $settings = seed_clp_array_add($settings,'text_subset','');
    $settings = seed_clp_array_add($settings,'button_font','Open Sans');
    $settings = seed_clp_array_add($settings,'button_color','#000000');
    $settings = seed_clp_array_add($settings,'element_border_color','#000000');
    $settings = seed_clp_array_add($settings,'form_border_color','#000000');
    $settings = seed_clp_array_add($settings,'form_color','#f5f5f5');
    $settings = seed_clp_array_add($settings,'button_size','14');
    $settings = seed_clp_array_add($settings,'button_weight','400');
    $settings = seed_clp_array_add($settings,'button_line_height','1');
    $settings = seed_clp_array_add($settings,'container_color','#ffffff');
    $settings = seed_clp_array_add($settings,'background_overlay','rgba(0,0,0,0.5)');
    $settings = seed_clp_array_add($settings,'container_position','1');
    $settings = seed_clp_array_add($settings,'container_width','600');
    $settings = seed_clp_array_add($settings,'form_width','100');
    $settings = seed_clp_array_add($settings,'container_radius','2');
    $settings = seed_clp_array_add($settings,'container_effect_animation','');
    $settings = seed_clp_array_add($settings,'txt_email_field','Email');
    $settings = seed_clp_array_add($settings,'txt_subscribe_button','Notify Me');
    $settings = seed_clp_array_add($settings,'txt_name_field','Name');
    $settings = seed_clp_array_add($settings,'txt_already_subscribed_msg',"You're already subscribed.");
    $settings = seed_clp_array_add($settings,'txt_invalid_email_msg','Invalid Email');
    $settings = seed_clp_array_add($settings,'txt_invalid_name_msg','Invalid Name');
    $settings = seed_clp_array_add($settings,'txt_stats_referral_url','Your Referral URL is:');
    $settings = seed_clp_array_add($settings,'txt_stats_referral_clicks','Clicks');
    $settings = seed_clp_array_add($settings,'txt_stats_referral_stats','Your Referral Stats');
    $settings = seed_clp_array_add($settings,'txt_stats_referral_subscribers','Conversion');
    $settings = seed_clp_array_add($settings,'txt_countdown_days','Days');
    $settings = seed_clp_array_add($settings,'txt_countdown_day','Day');
    $settings = seed_clp_array_add($settings,'txt_countdown_hours','Hours');
    $settings = seed_clp_array_add($settings,'txt_countdown_hour','Hour');
    $settings = seed_clp_array_add($settings,'txt_countdown_minutes','Minutes');
    $settings = seed_clp_array_add($settings,'txt_countdown_minute','Minute');
    $settings = seed_clp_array_add($settings,'txt_countdown_seconds','Seconds');
    $settings = seed_clp_array_add($settings,'txt_countdown_second','Second');
    return $settings;
}



/**
* Check per
*/
function seed_clp_cu( $rper = null ) {
    if(!empty($rper)){
        $uper = explode(",", get_option('seed_clp_per'));
        if(in_array($rper,$uper)){
            return true;
        }else{
            return false;
        }
    }else{
        $a = get_option('seed_clp_a');
        if($a){
            return true;
        }else{
            return false;
        }
    }
}


/**
 * Get Plugin API value
 */
function seed_clp_get_plugin_api_value($k = null) {
    return false;
    global $seed_clpv4;
    extract($seed_clpv4);
    if(!empty($plugin_api)){
        $plugin_api = str_replace(array("\n\r","\n"), "&", $plugin_api);
        parse_str($plugin_api, $plugin_api);
        if(array_key_exists($k, $plugin_api)){
            return $plugin_api[$k];
        }else{
            return false;
        }

    }
}

/**
 *  Get IP
 */
function seed_clp_get_ip(){
    $ip = '';
    if( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) AND strlen($_SERVER['HTTP_X_FORWARDED_FOR'])>6 ){
        $ip = strip_tags($_SERVER['HTTP_X_FORWARDED_FOR']);
    }elseif( !empty($_SERVER['HTTP_CLIENT_IP']) AND strlen($_SERVER['HTTP_CLIENT_IP'])>6 ){
         $ip = strip_tags($_SERVER['HTTP_CLIENT_IP']);
    }elseif(!empty($_SERVER['REMOTE_ADDR']) AND strlen($_SERVER['REMOTE_ADDR'])>6){
         $ip = strip_tags($_SERVER['REMOTE_ADDR']);
    }//endif
    if(!$ip) $ip="127.0.0.1";
    return strip_tags($ip);
}


/* Import nag */
add_action( 'admin_menu', 'seed_clp_import_nag' );

function seed_clp_import_nag(){
  // clpv4 nag
  if(isset($_GET['action']) && $_GET['action'] == 'seed_clp_dismiss_v4_nag'){
    update_option('seed_clp_dismiss_v4_nag',true);
  }
  $v4s = get_option('seed_clpv4');
  $v4_nag = get_option('seed_clp_dismiss_v4_nag');

  if((isset($_GET['page']) && $_GET['page'] == 'seed_clp') && !empty($v4s) && empty($v4_nag)){
    add_settings_error(
        null,
        'seed_clp_import_v4',
        'We have detected settings from Version 4, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_clp_import&v=clpv4">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_clp&action=seed_clp_dismiss_v4_nag">No</a>  ',
        'error'
    );
  }
  // coming-soon nag
  if(isset($_GET['action']) && $_GET['action'] == 'seed_clp_dismiss_coming_soon_nag'){
    update_option('seed_clp_dismiss_coming_soon_nag',true);
  }
  $coming_soon_s = get_option('seed_clp4_settings_content');
  $coming_soon_nag = get_option('seed_clp_dismiss_coming_soon_nag');

  if((isset($_GET['page']) && $_GET['page'] == 'seed_clp') && !empty($coming_soon_s) && empty($coming_soon_nag)){

    add_settings_error(
        null,
        'seed_clp_import_coming_soon',
        'We have detected settings from our Free Coming Soon and Maintenance Mode Plugin, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_clp_import&v=coming-soon">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_clp&action=seed_clp_dismiss_coming_soon_nag">No</a>  ',
        'error'
    );
  }
}


/* API nag */
add_action( 'admin_menu', 'seed_clp_api_nag' );

function seed_clp_api_nag(){
  $api_nag = get_option('seed_clp_api_nag');
  if((isset($_GET['page']) && $_GET['page'] == 'seed_clp') && !empty($api_nag)){
    add_settings_error(
        null,
        'seed_clp_api_nag',
        $api_nag,
        'error'
    );
  }
}

if(seed_clp_cu('none')){
  add_action( 'admin_menu', 'seed_clp_l_nag' );
}

function seed_clp_l_nag(){
  if((isset($_GET['page']) && $_GET['page'] == 'seed_clp')){
    add_settings_error(
        null,
        'seed_clp_l_nag',
        '<a href="index.php?page=seed_clp_welcome">Please enter a valid license key.</a>',
        'error'
    );
  }
}



function seed_clp_select($id,$option_values,$selected = null){
echo "<select id='$id' name='$id' class='form-control input-sm'>";
if(!empty($option_values)){
foreach ( $option_values as $k => $v ) {
	if(is_array($v)){
		echo '<optgroup label="'.ucwords($k).'">';
		foreach ( $v as $k1=>$v1 ) {
			echo '<option value="'.$k1.'"' . selected( $selected , $k1, false ) . ">$v1</option>";
		}
		echo '</optgroup>';
	}else{
			if(!isset($options[ $id ])){
				$options[ $id ] = '';
			}
    		echo "<option value='$k' " . selected( $selected , $k, false ) . ">$v</option>";
	}
}
}
echo "</select> ";
}



