/* Copyright (C) SeedProd LLC - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and redistribution is prohibitted.
 * Use by license purchased only at http://www.seedprod.com.
 * Written by John Turner <john@seedprod.com>, 2016
 */

jQuery(document).ready(function() {

    
    

    // Export

    jQuery('#export-settings').on('click',function(e){
        e.preventDefault();
        try{
        var jQuerybtn = jQuery(this).button('loading');
        }catch(err) {}
        var jqxhr = jQuery.get( export_page_ajax_url+'&page_id='+page_id, function(data) {
              jQuery('#import_export_settings').val(data);
            })
            .always(function() {
              try{
              jQuerybtn.button('reset');
              }catch(err) {}
            })
    });

    // Import
    jQuery('#import-settings').on('click',function(e){
        e.preventDefault();
        var data = jQuery('#import_export_settings').val();
        if(data != ''){
        try{
        var jQuerybtn = jQuery(this).button('loading');
        }catch(err) {}
        var jqxhr = jQuery.post( import_page_ajax_url+'&page_id='+page_id,data, function(data) {
              if(data != 'false'){
                // reload page
                timeout = true;
                location.reload();
              }else{
                toastr.error('Settings could not be imported.');
              }
            })
            .always(function() {
              try{
              jQuerybtn.button('reset');
              }catch(err) {}
            });
        }
    });

    // Publish Button
    jQuery('#publish-btn').on('click',function(e){
        save_page();
        //save_html();
    });
   // jQuery('#quick_nav').select2();
    jQuery('#quick_nav').change(function() {


            
  	    if(jQuery(this).val() == 'content'){
	            setTimeout(function(){location.href = "#header-content-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }  
	    if(jQuery(this).val() == 'social-profiles'){
	            setTimeout(function(){ location.href = "#header-social-profiles-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }     
	    if(jQuery(this).val() == 'background'){
	            setTimeout(function(){location.href = "#header-background-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }
	    if(jQuery(this).val() == 'container'){
	            setTimeout(function(){ location.href = "#header-container-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }
	    if(jQuery(this).val() == 'elements'){
	            setTimeout(function(){ location.href = "#header-elements-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }
	    if(jQuery(this).val() == 'typography'){
	            setTimeout(function(){location.href = "#header-typography-settings"; jQuery('#seed-clp-sidebar').scrollTop(  jQuery('#seed-clp-sidebar').scrollTop() - 170) ; }, 500);
	    }
	    if(jQuery(this).val() == 'custom-css'){
	            setTimeout(function(){location.href = "#header-custom-css-settings";  }, 500);
	    }
	    if(jQuery(this).val() == 'header-advanced-settings'){
	            setTimeout(function(){ location.href = "#header-advanced-settings"; }, 500);
	    }
    });
	//////////////  Content

    jQuery('#description').on('input',function(e){
        if(jQuery('#preview').contents().find('#clpio-login-desc').length == 0){
           jQuery('#preview').contents().find('#loginform').prepend('<div id="clpio-login-desc"></div>');
        }
        jQuery('#preview').contents().find('#clpio-login-desc').html(jQuery('#description').val().replace(/(?:\r\n|\r|\n)/g, '<br />'));
    });

    jQuery('#description_below').on('input',function(e){
        if(jQuery('#preview').contents().find('#clpio-login-desc-below').length == 0){
           jQuery('#preview').contents().find('#loginform').append('<div id="clpio-login-desc-below"></div>');
        }
        jQuery('#preview').contents().find('#clpio-login-desc-below').html(jQuery('#description_below').val().replace(/(?:\r\n|\r|\n)/g, '<br />'));
    });

    jQuery('#lost_password_msg').on('input',function(e){
        jQuery('#preview').contents().find('.login-action-lostpassword .message').html(jQuery('#lost_password_msg').val().replace(/(?:\r\n|\r|\n)/g, '<br />'));
    });

    jQuery('#registration_msg').on('input',function(e){
        jQuery('#preview').contents().find('.login-action-register .message').html(jQuery('#registration_msg').val().replace(/(?:\r\n|\r|\n)/g, '<br />'));
    });

    jQuery('#u_e_txt').on('input',function(e){
        jQuery('#preview').contents().find("label[for='user_login']")
          // get all child nodes including text and comment
          .contents()
          // iterate and filter out elements
          .filter(function() {
            // check node is text and non-empty
            return this.nodeType === 3 && this.textContent.trim().length;
            // replace it with new text
          }).replaceWith(jQuery('#u_e_txt').val());
    });

    jQuery('#pass_txt').on('input',function(e){
        jQuery('#preview').contents().find("label[for='user_pass']")
          // get all child nodes including text and comment
          .contents()
          // iterate and filter out elements
          .filter(function() {
            // check node is text and non-empty
            return this.nodeType === 3 && this.textContent.trim().length;
            // replace it with new text
          }).replaceWith(jQuery('#pass_txt').val());
    });

    jQuery('#remember_txt').on('input',function(e){
        jQuery('#preview').contents().find("label[for='rememberme']")
          // get all child nodes including text and comment
          .contents()
          // iterate and filter out elements
          .filter(function() {
            // check node is text and non-empty
            return this.nodeType === 3 && this.textContent.trim().length;
            // replace it with new text
          }).replaceWith(jQuery('#remember_txt').val());
    });

    jQuery('#login_txt').on('input',function(e){
        jQuery('#preview').contents().find('#wp-submit').val(jQuery('#login_txt').val());
    });

    jQuery('#register_txt').on('input',function(e){
        jQuery('#preview').contents().find('#nav a[href*="register"]').text(jQuery('#register_txt').val());
    });

    jQuery('#lost_txt').on('input',function(e){
        jQuery('#preview').contents().find('#nav a[href*="lostpassword"]').text(jQuery('#lost_txt').val());
    });

    jQuery('#back_txt').on('input',function(e){
        jQuery('#preview').contents().find('#backtoblog a').text(jQuery('#back_txt').val());
    });

    jQuery('#form_m_t').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('margin-top',jQuery('#form_m_t').val()+'px');
    });

    jQuery('#form_m_r').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('margin-right',jQuery('#form_m_r').val()+'px');
    });

    jQuery('#form_m_b').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('margin-bottom',jQuery('#form_m_b').val()+'px');
    });

    jQuery('#form_m_l').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('margin-left',jQuery('#form_m_l').val()+'px');
    });

    jQuery('#form_p_t').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('padding-top',jQuery('#form_p_t').val()+'px');
    });

    jQuery('#form_p_r').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('padding-right',jQuery('#form_p_r').val()+'px');
    });

    jQuery('#form_p_b').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('padding-bottom',jQuery('#form_p_b').val()+'px');
    });

    jQuery('#form_p_l').on('input',function(e){
        jQuery('#preview').contents().find('#loginform').css('padding-left',jQuery('#form_p_l').val()+'px');
    });




	// Enable Social Profiles
	if (jQuery('#enable_socialprofiles').is(':checked')) {
        jQuery("#socialprofiles_settings").show();
    }else{
        jQuery("#socialprofiles_settings").hide();
    }
    

    jQuery("#enable_socialprofiles").change(function() {
	    if(this.checked) {
	        jQuery("#socialprofiles_settings").fadeIn();
	        save_page();
	    }else{
	        jQuery("#socialprofiles_settings").fadeOut();
	        save_page();
	    }
    });

    // Social Profile Logic
    jQuery( "#social_profiles_repeatable_container" ).sortable({
      placeholder: "ui-state-highlight",
      start: function(e, ui){
        ui.placeholder.height(ui.item.height());
    }
    });
    //jQuery( "#social_profiles_repeatable_container" ).disableSelection();
    jQuery( "#social_profiles_repeatable_container" ).on( "sortstop", function( event, ui ) { save_page()} )
    jQuery("#social_profiles_repeatable_container").repeatable({
        template: "#social_profiles_template",
        onAdd: add_fa_dropdown,
        onDelete: remove_fa_dropdown,
        startWith: s_c
    });

	
	// Font Awesome Profile Icons
	function add_fa_dropdown(){
	    jQuery('.icp-dd').iconpicker({
	        icons: ['fa-facebook-official','fa-twitter','fa-linkedin','fa-google-plus','fa-youtube','fa-flickr','fa-vimeo','fa-pinterest','fa-instagram','fa-foursquare', 'fa-skype','fa-tumblr', 'fa-github','fa-500px', 'fa-dribbble','fa-slack','fa-soundcloud', 'fa-rss', 'fa-envelope'],
	        hideOnSelect: true
	    });
	    jQuery('.icp-dd').on('iconpickerSetValue', function (e) {
	        var i = jQuery(this).attr('id').match(/\d+/)[0];
	        jQuery("#icon_" + i).val(e.iconpickerValue);
	        jQuery(this).parents('.btn-group').removeClass('open');
	        save_page();
	    });

	}

	function remove_fa_dropdown(){
	    jQuery(this).parent().parent().parent().remove();
	    save_page();
	}

	add_fa_dropdown();

	// Social Profile Size
	jQuery('#social_profiles_size').change(function() {
	    if(jQuery(this).val() == ""){
	        jQuery('#preview').contents().find('.fa').removeClass('fa-lg fa-2x fa-3x fa-4x fa-5x');   
	    }else{
	        jQuery('#preview').contents().find('.fa').removeClass('fa-lg fa-2x fa-3x fa-4x fa-5x'); 
	        jQuery('#preview').contents().find('.fa').addClass(jQuery(this).val()); 
	    }
	    
	    save_page(false);
	});

	// Social Profile Blank
	jQuery("#social_profiles_blank").change(function() {
	    if(this.checked) {
	        jQuery('#preview').contents().find('.fa').parent().prop('target','_blank');
	    }else{
	        jQuery('#preview').contents().find('.fa').parent().prop('target','_self');
	    }
	    save_page(false);
	});



    // Background Color
    jQuery('.background_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
      jQuery('#preview').contents().find('body').css('background-color',event.color.toHex());
    });

    // Background Image Picker
    jQuery("#image-picker").on("show.bs.modal", function(e) {
        p = page
        get_posts(p);
    });


    //Background Advanced Settings
    if (jQuery('#enable_background_adv_settings').is(':checked')) {
        jQuery("#background_adv_settings").show();
    }else{
        jQuery("#background_adv_settings").hide();
    }

    jQuery("#enable_background_adv_settings").change(function() {
    if(this.checked) {
        jQuery("#background_adv_settings").fadeIn();
    }else{
        jQuery("#background_adv_settings").hide();
    }
    });

    //Logo Settings
    if (jQuery('#hide_logo').is(':checked')) {
        jQuery("#logo_settings").hide();
    }else{
        jQuery("#logo_settings").show();
    }

    jQuery("#hide_logo").change(function() {
    if(this.checked) {
        jQuery("#logo_settings").hide();
        jQuery('#preview').contents().find('#login h1:first-child ').hide();
    }else{
        jQuery("#logo_settings").show();
        jQuery('#preview').contents().find('#login h1:first-child ').show();
    }
    });



    //Hide Remember Mr Settings
    jQuery("#hide_remember_me").change(function() {
    if(this.checked) {
        jQuery('#preview').contents().find('.forgetmenot').hide();
    }else{
        jQuery('#preview').contents().find('.forgetmenot').show();
    }
    });

    //Hide Forgot Password Settings
    jQuery("#hide_forgot_password").change(function() {
    if(this.checked) {
        jQuery('#preview').contents().find('#nav').hide();
    }else{
        jQuery('#preview').contents().find('#nav').show();
    }
    });

    //Hide Back Link Settings
    jQuery("#hide_back_link").change(function() {
    if(this.checked) {
        jQuery('#preview').contents().find('#backtoblog').hide();
    }else{
        jQuery('#preview').contents().find('#backtoblog').show();
    }
    });


    //Background Advanced Settings
    if (jQuery('#enable_background_overlay').is(':checked')) {
        jQuery("#background_overlay").parents('.form-group').show();
    }else{
        jQuery("#background_overlay").parents('.form-group').hide();
    }
    

    jQuery("#enable_background_overlay").change(function() {
    if(this.checked) {
        jQuery("#background_overlay").parents('.form-group').fadeIn();
        jQuery('#preview').contents().find('#clpio-page').css('background-color',"rgba("+jQuery("#background_overlay").val()+")");
    }else{
        jQuery("#background_overlay").parents('.form-group').hide();
        jQuery('#preview').contents().find('#clpio-page').css('background-color',"transparent");
    }
    });

    // Background Overlay
    jQuery('.background_overlay_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
      if(jQuery('#enable_background_overlay').is(':checked')){
        jQuery('#preview').contents().find('#clpio-page').css('background-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
      }
    });

    // Background Size
    jQuery('#background_size').change(function() {
        save_page(false);
        jQuery('#preview').contents().find('body').css('background-size',jQuery('#background_size').val());
    });

    jQuery('#background_repeat').change(function() {
        save_page(false);
        jQuery('#preview').contents().find('body').css('background-repeat',jQuery('#background_repeat').val());
    });

    jQuery('#background_position').change(function() {
        save_page(false);
        jQuery('#preview').contents().find('body').css('background-position',jQuery('#background_position').val());
    });

    jQuery('#background_attachment').change(function() {
        save_page(false);
        jQuery('#preview').contents().find('body').css('background-attachment',jQuery('#background_attachment').val());
    });

    // Background Slideshow
    jQuery( "#slides" ).sortable({
      placeholder: "ui-state-highlight",
      start: function(e, ui){
        ui.placeholder.height(ui.item.height());
    }
    });
    //jQuery( "#slides" ).disableSelection();

    if (jQuery('#bg_slideshow').is(':checked')) {
        jQuery("#bg_slideshow_settings").show();
    }else{
        jQuery("#bg_slideshow_settings").hide();
    }
    

    jQuery("#bg_slideshow").change(function() {
    if(this.checked) {
        jQuery("#bg_slideshow_settings").fadeIn();
        save_page();
    }else{
        jQuery("#bg_slideshow_settings").fadeOut();
        save_page();
    }
    });

    jQuery("#bg_slideshow_randomize").change(function() {
        save_page();
    });
    
    // Container Radius
    jQuery("#bg_slideshow_slide_speed_slider").noUiSlider({
        start: bg_slideshow_slide_speed,
        connect: "lower",
        step: 1,
        range: {
            'min': 0,
            'max': 20
        },
        format: wNumb({
            decimals: 0
        })
    });

    jQuery("#bg_slideshow_slide_speed_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
        // The tooltip HTML is 'this', so additional
        // markup can be inserted here.
        jQuery(this).html(
            '<div class="tooltip-inner">' +
            '<span>' + value + ' sec</span>' +
            '</div>'
        );
        jQuery('#bg_slideshow_slide_speed').val(value);
    });
    

    jQuery('.slide-delete').on('click',function(e){
      index = jQuery( "#slides" ).find('input[name^="bg_slideshow_images"]').length  ;
      //console.log(index);
      if(index == 1){
        jQuery(this).parent().find('input[name^="bg_slideshow_images"]').val('');
        jQuery(this).parent().find('img').prop('src',blank_gif)
      }else{
        jQuery(this).parent().remove();
      }
      save_page();
  });

    // Background Video
    if (jQuery('#bg_video').is(':checked')) {
        jQuery("#bg_video_settings").show();
    }else{
        jQuery("#bg_video_settings").hide();
    }
    

    jQuery("#bg_video").change(function() {
    save_page();
    if(this.checked) {
        jQuery("#bg_video_settings").fadeIn();
    }else{
        jQuery("#bg_video_settings").fadeOut();
    }
    });

    // Container Transparent
    if (jQuery('#container_transparent').is(':checked')) {
        jQuery("#container_color").parent().parent().hide();
        jQuery("#container_radius").parent().hide();
    }else{
        jQuery("#container_color").parent().parent().show();
        jQuery("#container_radius").parent().show();
    }

    jQuery("#container_transparent").change(function() {
    if(this.checked) {
        jQuery("#container_color").parent().parent().fadeOut();
        jQuery("#container_radius").parent().fadeOut();
        jQuery('#preview').contents().find('.login form').css({'background-color':"transparent","-webkit-box-shadow":"none","box-shadow":"none"});
        save_page(false);
    }else{
        jQuery("#container_color").parent().parent().fadeIn();
        jQuery("#container_radius").parent().fadeIn();
        jQuery('#preview').contents().find('.login form').css('background-color',jQuery('#container_color').val()).css({"-webkit-box-shadow":"0 1px 3px rgba(0,0,0,0.13)","box-shadow":"0 1px 3px rgba(0,0,0,0.13)"});
        save_page(false);
    }
    });   

    // Container Color
    jQuery('.container_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
      jQuery('#preview').contents().find('.login form').css('background-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    });

    // Container Radius
    jQuery("#container_radius_slider").noUiSlider({
        start: container_radius,
        connect: "lower",
        step: 1,
        range: {
            'min': 0,
            'max': 100
        },
        format: wNumb({
            decimals: 0
        })
    });

    jQuery("#container_radius_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
        // The tooltip HTML is 'this', so additional
        // markup can be inserted here.
        jQuery(this).html(
            '<div class="tooltip-inner">' +
            '<span>' + value + 'px</span>' +
            '</div>'
        );
        jQuery('#container_radius').val(value);
        jQuery('#preview').contents().find('.login form,.login').css('border-radius', value+"px");

    });

    // Logo Margin Bottom
    jQuery("#logo_margin_bottom_slider").noUiSlider({
        start: logo_margin_bottom,
        connect: "lower",
        step: 1,
        range: {
            'min': 0,
            'max': 500
        },
        format: wNumb({
            decimals: 0
        })
    });

    jQuery("#logo_margin_bottom_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
        // The tooltip HTML is 'this', so additional
        // markup can be inserted here.
        jQuery(this).html(
            '<div class="tooltip-inner">' +
            '<span>' + value + 'px</span>' +
            '</div>'
        );
        jQuery('#logo_margin_bottom').val(value);
        jQuery('#preview').contents().find('#login h1:first-child').css('margin-bottom', value+"px");

    });

    // Error Message Radius
    jQuery("#error_msg_radius_slider").noUiSlider({
        start: error_msg_radius,
        connect: "lower",
        step: 1,
        range: {
            'min': 0,
            'max': 100
        },
        format: wNumb({
            decimals: 0
        })
    });

    jQuery("#error_msg_radius_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
        // The tooltip HTML is 'this', so additional
        // markup can be inserted here.
        jQuery(this).html(
            '<div class="tooltip-inner">' +
            '<span>' + value + 'px</span>' +
            '</div>'
        );
        jQuery('#error_msg_radius').val(value);
        jQuery('#preview').contents().find(' .message, .login #login_error').css('border-radius', value+"px");

    });


    // Container Position
    var previous_container_position;

    jQuery('#container_position').on('focus', function () {
        previous_container_position = this.value;
    })

    jQuery('#container_position').on('change',function(e){
        if(jQuery(this).val() == '0'){
            save_page();
        }

    	if(jQuery(this).val() == '1'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','center');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','center');
            //jQuery('#preview').contents().find('.flexbox #clpio-page').animate({'align-items': center,'justify-content':center});
    	}
      	if(jQuery(this).val() == '2'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-start');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','center');
    	}
        if(jQuery(this).val() == '3'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-end');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','center');
    	}
    	if(jQuery(this).val() == '4'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','center');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-start');
    	}
    	if(jQuery(this).val() == '5'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-start');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-start');
    	}
    	if(jQuery(this).val() == '6'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-end');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-start');
    	}
    	if(jQuery(this).val() == '7'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','center');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-end');
    	}
     	if(jQuery(this).val() == '8'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-start');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-end');
    	}
     	if(jQuery(this).val() == '9'){
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('align-items','flex-end');
    		jQuery('#preview').contents().find('.flexbox #clpio-page').css('justify-content','flex-end');
    	}

        if( previous_container_position == '0'){
            save_page();
        }else{
            save_page(false);
        }

        previous_container_position = this.value;

    });

    // Container Width
    jQuery("#container_width_slider").noUiSlider({
        start: container_width,
        connect: "lower",
        step: 1,
        range: {
            'min': 200,
            'max': 2000
        },
        format: wNumb({
            decimals: 0
        })
    });



    jQuery("#container_width_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
        // The tooltip HTML is 'this', so additional
        // markup can be inserted here.
        jQuery(this).html(
            '<div class="tooltip-inner">' +
            '<span>' + value + 'px</span>' +
            '</div>'
        );
        jQuery('#container_width').val(value);
        jQuery('#preview').contents().find('#login').css('max-width',value + 'px');

    });
    
        // Form Width
    // jQuery("#form_width_slider").noUiSlider({
    //     start: form_width,
    //     connect: "lower",
    //     step: 1,
    //     range: {
    //         'min': 0,
    //         'max': 100
    //     },
    //     format: wNumb({
    //         decimals: 0
    //     })
    // });



    // jQuery("#form_width_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
    //     // The tooltip HTML is 'this', so additional
    //     // markup can be inserted here.
    //     jQuery(this).html(
    //         '<div class="tooltip-inner">' +
    //         '<span>' + value + '%</span>' +
    //         '</div>'
    //     );
    //     jQuery('#form_width').val(value);
    //     jQuery('#preview').contents().find('#clpio-field-wrapper').css('max-width',value + '%');

    // });

    // Element Color
    jQuery('.button_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
      //if(jQuery('#container_flat').val() == '1'){
      jQuery('#preview').contents().find(' #clpio-social-profiles a,#clpio-login-desc a,#clpio-login-desc-below a').css('color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
      jQuery('#preview').contents().find('.button-primary').css('background-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
      //jQuery('#preview').contents().find('.button-primary').css('border-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
      var dark_color1 = jQuery.Color(jQuery('#button_color').val()).lightness('-=0.1').toRgbaString();
      var dark_color3 = jQuery.Color(jQuery('#button_color').val()).lightness('-=0.2').toRgbaString();
      var light_color3 = jQuery.Color(jQuery('#button_color').val()).lightness('+=0.2').toRgbaString();

      if(jQuery('#button_flat:checked')){
      jQuery('#preview').contents().find('.button-primary').css('border-color',dark_color1);
      jQuery('#preview').contents().find('.button-primary').css('box-shadow','0 1px 0 '+dark_color3);
      }
      



      var lightness = jQuery.Color(jQuery('#button_color').val()).lightness();
      if(lightness >= 0.65){
        var color = '#000';
        jQuery('#preview').contents().find('.button-primary').css('color','#000');
        if(jQuery('#button_flat:checked')){
        jQuery('#preview').contents().find('.button-primary').css('text-shadow','0 -1px 1px '+light_color3+',1px 0 1px '+light_color3+',0 1px 1px '+light_color3+',-1px 0 1px '+light_color3+'');
        }
      }else{
        var color = '#fff';
        jQuery('#preview').contents().find('.button-primary').css('color','#fff');
        if(jQuery('#button_flat:checked')){
        jQuery('#preview').contents().find('.button-primary').css('text-shadow','0 -1px 1px '+dark_color3+',1px 0 1px '+dark_color3+',0 1px 1px '+dark_color3+',-1px 0 1px '+dark_color3+'');
        }
      }

      //}

    });
    
    jQuery('#button_color').on('blur',function(e){
            save_page(false);
	});




    
    //Element Border Color
    
    // jQuery('.element_border_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
    //   jQuery('#preview').contents().find('#clpio-subscribe-btn,.clpio .progress').css('border',"1px solid rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");

    //   if(jQuery('#preview').contents().find('#tmp-countdown-border-style').length == 0){
    //     jQuery('#preview').contents().find('head').append("<style id='tmp-countdown-border-style' type='text/css'></style>");
    //   }
      

    //   jQuery('#preview').contents().find('#tmp-countdown-border-style').html('.countdown_section{border: 1px solid rgba('+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+');}');



    // });
    
    // Form Input Background Color
    jQuery('.form_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
      jQuery('#preview').contents().find('input').not("input[type='submit']").css('background-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");


      if(jQuery('#preview').contents().find('#tmp-form-style').length == 0){
        jQuery('#preview').contents().find('head').append("<style id='tmp-form-style' type='text/css'></style>");
      }
      

      var lightness = jQuery.Color(jQuery('#form_color').val()).lightness();
      if(lightness >= 0.65){
        var color = '#999';
        var textcolor = "#000";
      }else{
        var color = '#999';
        var textcolor = "#fff";
      }
      jQuery('#preview').contents().find('input').not("input[type='submit']").css('color',textcolor);

      jQuery('#preview').contents().find('#tmp-form-style').html('::-webkit-input-placeholder {color:'+color+' !important};:-moz-placeholder {color:'+color+' !important};::-moz-placeholder {color:'+color+' !important};:-ms-input-placeholder {color:'+color+' !important};');

    });
    
    //Form Input Border Color
    
    // jQuery('.form_border_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){
    //   jQuery('#preview').contents().find('input').css('border',"1px solid rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    // });

    // Container Animation
    jQuery('#container_effect_animation').val(container_effect_animation);
    jQuery('#container_effect_animation').change(function() {
        if(jQuery('#preview').contents().find('#animated-css').length == 0) {
            url='https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.4.0/animate.min.css';
            jQuery('#preview').contents().find('head').append('<link id="animated-css" rel="stylesheet" href="'+url+'" type="text/css" />');
        }
        jQuery('#preview').contents().find('#login').removeClass();
        jQuery('#preview').contents().find('#login').addClass('animated ' + jQuery(this).val());
        save_page(false);
    });

    // Custom CSS
    jQuery('#custom_css').on("input", function (e) { 
        jQuery('#preview').contents().find('#tmp-custom-css-style').remove();
        jQuery('#preview').contents().find('head').append("<style id='tmp-custom-css-style' type='text/css'></style>");
        jQuery('#preview').contents().find('#tmp-custom-css-style').html(jQuery('#custom_css').val());

    });
    

    // Fonts Stuff
    jQuery('#text_font').select2();


    jQuery('.text_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){

      jQuery('#preview').contents().find('#clpio-login-desc,#clpio-login-desc-below,.login label').css('color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    });

    jQuery('.text_link_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){

      jQuery('#preview').contents().find(' .login #nav a, .login #backtoblog a').css('color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    });


    jQuery('.error_msg_txt_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){

      jQuery('#preview').contents().find('#login_error, .message').css('color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    });

    jQuery('.error_msg_bg_color_picker').colorpicker({ component: '.form-control, .add-on, .input-group-addon' }).on('changeColor.colorpicker', function(event){

      jQuery('#preview').contents().find('#login_error, .message').css('background-color',"rgba("+event.color.toRGB().r+","+event.color.toRGB().g+","+event.color.toRGB().b+","+event.color.toRGB().a+")");
    });



    jQuery('#text_line_height').on('input',function(e){
      jQuery('#preview').contents().find('body').css('line-height',jQuery('#text_line_height').val() + 'px');
    });
    
    if(jQuery('#publish_method').val() == 'download'){
        jQuery("#auth_code").parent().parent().hide();
        jQuery("#url").parent().show();
    }
    if(jQuery('#publish_method').val() == 'wordpress'){
        jQuery("#auth_code").parent().parent().show();
        jQuery("#url").parent().hide();
    }
    
    jQuery('#publish_method').change(function() {
        if(jQuery('#publish_method').val() == 'download'){
            jQuery("#auth_code").parent().parent().hide();
            jQuery("#url").parent().show();
        }
        if(jQuery('#publish_method').val() == 'wordpress'){
            jQuery("#auth_code").parent().parent().show();
            jQuery("#url").parent().hide();
        }
    });


    //Recapcha
    if (jQuery('#enable_recaptcha').is(':checked')) {
        jQuery("#recaptcha_adv_settings").show();
    }else{
        jQuery("#recaptcha_adv_settings").hide();
    }
    

    jQuery("#enable_recaptcha").change(function() {
    if(this.checked) {
        jQuery("#recaptcha_adv_settings").fadeIn();
    }else{
        jQuery("#recaptcha_adv_settings").hide();
    }
    });




}); // end doc ready


// Start Font



// End Font

// Functions
function remove_slides(){
    jQuery(this).remove();
}

// Dim iframe while changes are made.
jQuery(document)
.ajaxStart(function () {
    
})
.ajaxStop(function () {
    
});

jQuery('#preview').load(function(){
 // console.log('clear');
  clearTimeout(timeout);
  jQuery('#ajax-status').hide();
  jQuery('#preview').animate({
    opacity: "1"
}, 500); 
});

function save_html(refresh){
    jQuery.get( "ajax/test.html", function( data ) {
      $( ".result" ).html( data );
      alert( "Load was performed." );
    });
}

// Save Settings
function save_page(refresh){
    if(typeof refresh === 'undefined'){
        refresh = true;
    }
    // Clear any errors
    jQuery(".help-block").remove();
    jQuery(".form-group").removeClass('has-error');
    try{
    jQuery("#publish-btn").button('loading');
    }catch(err) {}

    // Submit data
    var dataString = jQuery( '#seed_clp_customizer' ).serialize();
    //console.log(dataString);

    if(dataString == ''){
        return 'false';
    }
    
    jQuery.ajax({
        type: "POST",
        url : save_url,
        data : dataString,
        beforeSend : function(data){
                if(refresh){
                    //console.log('timeout');
                    jQuery('#preview').css('opacity','0');
                    jQuery('#ajax-status').show();

                    
                    // timeout = setTimeout(function(){
                    //     location = ''
                    //   },10000);
                }
        },
        success : function(data){
            if(data == 'true'){
                try{
                jQuery("#publish-btn").button('reset');
                }catch(err) {}
                if(refresh){
                document.getElementById('preview').contentWindow.location.reload(true);
                }
                if(refresh == 'hard'){
                    location.refresh();
                }
                return true;
            }else{
                //console.log(jQuery.parseJSON(data));
                errors = '';
                jQuery.each( jQuery.parseJSON(data), function( key, value ) {
                  errors =  errors + "<li>"+value+"</li>";
                });
                toastr.options.timeOut = 15000;
                toastr.options.progressBar = true;
                toastr.error('Your settings could not be saved. Please make sure these fields are not empty. <ul style="list-style-type: circle;font-size:11px">'+errors+'</ul>');
            }
            

        },
        error: function(data){
            if(data.status == '403'){
                jQuery('#preview').css('opacity','1');
                jQuery('#ajax-status').hide();
                toastr.error('Your settings could not be saved. The WordFence Firewall is blocking the Save. Please set the Firewall to Learning Mode while building this page.');
            }else{
                toastr.error('Your settings could not be saved. Refresh the page and try again. Please contact Support if you continue to experience this issue.');
            }
            //alert('Your settings could not be saved. Please open a Support Ticket so we can identify the issue.');
            // var errors = data.responseJSON;
            // jQuery.each( errors, function( key, value ) {
            //     jQuery( "#"+key ).parent().append("<span class='help-block'>"+value+"</span>").addClass('has-error');
            // });
        }
    });
}

//Image Functions
jQuery( "#logo,#background_image" ).change(function() {
  update_image_preview(this);
});
function update_image_preview(el){
    var file = jQuery(el).val();
    jQuery(el).parent().find(".img-preview img").prop('src',file);
    jQuery(el).parent().find(".img-preview").show();
    var id = jQuery(el).attr('id');
    if(id == 'logo'){
        jQuery('#preview').contents().find('#clpio-logo').prop('src', file);
    }
    if(id == 'background_image'){
        jQuery('#preview').contents().find('body').css('background-image', 'url('+file+")");
        jQuery('#preview').contents().find('body').css('background-size',jQuery('#background_size').val());
    	jQuery('#preview').contents().find('body').css('background-repeat',jQuery('#background_repeat').val());
    	jQuery('#preview').contents().find('body').css('background-position',jQuery('#background_position').val());
    	jQuery('#preview').contents().find('body').css('background-attachment',jQuery('#background_attachment').val()); 
    }

    //console.log('trigger');
    save_page();
}

jQuery( "#bg_slideshow_tmp" ).change(function() {
  update_slides(this);
});

function update_slides(el){
    var file = jQuery(el).val();
    jQuery(el).val('');
    index = jQuery( "#slides" ).find('input[name^="bg_slideshow_images"]').length  ;
    //console.log(index);
    if(jQuery("#bg_slideshow_images_"+ (index - 1)).val() == ''){
        //console.log('current');
        jQuery("#bg_slideshow_images_"+(index - 1)).val(file);
        jQuery("#bg_slideshow_images_"+(index - 1)).parent().find('img').prop('src',file);
    }else{
        //console.log('new');
        jQuery("#bg_slideshow_images_"+(index - 1)).parent().clone().insertAfter("#slides .input-group:last").find("input").prop('id',"bg_slideshow_images_"+ index).prop('name',"bg_slideshow_images["+index+"]");
        jQuery("#bg_slideshow_images_"+index).val(file);
        jQuery("#bg_slideshow_images_"+index).parent().find('img').prop('src',file);
    }
    save_page();

        jQuery('.slide-delete').on('click',function(e){
      index = jQuery( "#slides" ).find('input[name^="bg_slideshow_images"]').length  ;
      //console.log(index);
      if(index == 1){
        jQuery(this).parent().find('input[name^="bg_slideshow_images"]').val('');
        jQuery(this).parent().find('img').prop('src',blank_gif)
      }else{
        jQuery(this).parent().remove();
      }
      save_page();
  });
};

function get_posts(p){

    url = index_backgrounds+'&page='+page;

    jQuery.get( url, function( data ) {

        jQuery("#image-picker .modal-body").html(data);

        jQuery('.grid').imagesLoaded( {
          // options...
          },
          function() {
              jQuery('.grid').masonry({
                // options
                  itemSelector: '.grid-item',
                  columnWidth: 200,
                  gutter: 10
                });

          }
        );

        jQuery('.pagination a').click(function (e) {
            e.preventDefault();
            page = jQuery(this).attr('href').split('page=')[1];
            get_posts(page);
        });

        jQuery( ".bg-images" ).on( "click", function() {

            var reg = jQuery( this ).attr('data-reg');
            var thumb = jQuery( this ).attr('data-thumb');
            // console.log(thumb);
            // return false;
            jQuery('#image-picker').modal('hide')
    
            // Save
            jQuery("#background_image").val(reg);
            jQuery("#background_image").parent().find(".img-preview img").prop('src',thumb);
            jQuery("#background_image").parent().find(".img-preview").show();
    
            // Show
            jQuery('#preview').contents().find('html').css('background-image', 'url('+reg+")");
            jQuery('#preview').contents().find('html').css('background-size',jQuery('#background_size').val());
            jQuery('#preview').contents().find('html').css('background-repeat',jQuery('#background_repeat').val());
            jQuery('#preview').contents().find('html').css('background-position',jQuery('#background_position').val());
            jQuery('#preview').contents().find('html').css('background-attachment',jQuery('#background_attachment').val());
            
            //Sideload Image to WordPress
            jQuery.get( sideload_backgrounds+'&image='+encodeURIComponent(reg), function( data ) {
                    if(data != '0'){ 
                        jQuery("#background_image").val(data);
                    }
            }).always(function() {
                save_page(false);
            });
        });
    });




};







// Global //

// Save before close
jQuery(window).bind('beforeunload', function(e) {
    if(timeout === undefined){
    if(jQuery('#preview').attr('src') == preview_url){
      //save_page(false);
    }
    // var message = "Why are you leaving?";
    // e.returnValue = message;
    // return message;
    }
});
jQuery(document).ready(function() {
    //save_page(false);
});

jQuery(document).ready(function() {
    // Previews
    jQuery('#preview_desktop').on('click',function(e){
      jQuery("#preview-wrapper").removeClass('phone-wireframe');
      jQuery('#preview').contents().find('#tubular-container,#big-video-wrap').show();
      jQuery('#preview').animate({
        width: "100%",
        height: "100%",
        'padding-top': "0px"
    }, 500); 
    });

    jQuery('#preview_mobile').on('click',function(e){
      jQuery("#preview-wrapper").addClass('phone-wireframe');
      jQuery('#preview').contents().find('#tubular-container,#big-video-wrap').hide();
      jQuery('#preview').animate({
        width: "329px",
        height: "680px",
        'padding-top': "94px"
    }, 500); 
  });
  
   jQuery('#refresh_page').on('click',function(e){
      jQuery("#preview").attr('src',preview_url)
  });

	// Tooltips
	jQuery('[data-toggle="tooltip"]').tooltip();


	// Image Preview Delete
	jQuery('.img-preview .fa').click(function() {
	    jQuery(this).prev().prop('src',blank_gif);
	    jQuery(this).parent().parent().find("input:text,input:hidden").val('');
	    jQuery(this).parent().fadeOut();
	    save_page();
	});

	// Save Page Events
	jQuery('#error_invalid_username,#error_invalid_password,#error_empty_username,#error_empty_password,#form_b_t,#form_b_b,#form_b_r,#form_b_l,#form_m_t,#form_m_b,#form_m_r,#form_m_l,#u_e_txt,#pass_txt,#remember_txt,#register_txt,#register_link,#login_txt,#lost_txt,#back_txt,#recaptcha_site_key,#url,#publish_method,#headline_color,#headline_line_height,#text_color,#error_msg_txt_color, #error_msg_bg_color, #text_link_color,#text_size,#text_line_height,#container_color,#form_color,.note-editable,#background_color,#background_overlay,#footer_credit_text, #footer_credit_link, #footer_affiliate_link, #headline, #description,#lost_password_msg,#registration_msg,#description_below, #privacy_policy_link_text,#thankyou_msg,#tweet_text,#seo_title, #seo_description, #ga_analytics,#txt_subscribe_button,#txt_email_field,#txt_name_field,#txt_already_subscribed_msg,#txt_invalid_email_msg,#txt_invalid_name_msg,#txt_stats_referral_stats,#txt_stats_referral_url,#txt_stats_referral_clicks,#txt_stats_referral_subscribers').on('blur',function(e){
	    save_page(false);
	});


	jQuery('#logo_link, #logo_alt,#recaptcha_secret_key,#typekit_id,#header_scripts,#footer_scripts,#conversion_scripts,#custom_css,input[id^="social_profiles"],#bg_video_url,#progress_bar_start_date,#progress_bar_end_date,#countdown_date,#countdown_format,#txt_countdown_days,#txt_countdown_day,#txt_countdown_hours,#txt_countdown_hour,#txt_countdown_minutes, #txt_countdown_minute,#txt_countdown_days,#txt_countdown_day,#countdown_timezone').on('blur',function(e){
	    save_page();
	});

	jQuery("#button_flat,#enable_reflink,#credit_type,#enable_fitvid,#enable_retinajs,#enable_recaptcha,#enable_wp_head_footer,#bg_video_audio, #bg_video_loop,#display_name,#bg_slideshow_slide_transition,#progressbar_effect,#container_flat").change(function() {
	    save_page();
	});

	jQuery("#hide_remember_me,#hide_forgot_password,#hide_back_link,#hide_logo,#enable_fraud_detection,#enable_background_overlay,#countdown_launch,#require_name,#logo_margin_bottom_slider,#container_radius_slider,#error_msg_radius_slider,#progressbar_percentage_slider,#publish_method").change(function() {
	    save_page(false);
	});

	// Global Slider Save
    jQuery(document).on('mouseup','.noUi-handle',function(e) {
        var el = jQuery(this).parents('#bg_slideshow_slide_speed_slider');
        var id = jQuery(el).attr('id');
        if(id == 'bg_slideshow_slide_speed_slider'){
    	   save_page();
        }else{
           save_page(false); 
        }
	});

    //Show hide adv fields
    jQuery("#show_hide_adv_fields").change(function() {
    if(this.checked){
        jQuery(".adv").fadeOut();
    }else{
        jQuery(".adv").fadeIn();
    }

});




}); // end doc ready

// switchery
var elems = Array.prototype.slice.call(document.querySelectorAll('.switchery'));
// Success color: #10CFBD
elems.forEach(function(html) {
  var switchery = new Switchery(html, {color: '#0085BA', size: 'small'});
});


        


// Text Font

    function set_text_font_extras(el){
        if(jQuery(el).val().indexOf(',') == -1){
             font_name = jQuery(el).val().replace(/\+/g, " ").replace(/\'/g, "");
             //console.log(font_name);
             font = google_fonts[font_name];
             jQuery('#text_weight, #text_subset').parent().fadeIn();
            //console.log(font);


            // load weights and style
            jQuery('#text_weight').find('option').remove();
            //jQuery('#text_weight').append('<option value="">Default</option>');
            //onsole.log(font);
            jQuery.each(font.variants,function(key, value) 
            {
                jQuery('#text_weight').append('<option value=' + value.id + '>' + value.name + '</option>');
            });

            
            if(text_weight != ''){
                jQuery('#text_weight').val(text_weight);
            }else{
                if(jQuery("#text_weight option[value='400']").length > 0){
                jQuery('#text_weight').val('400'); 
                }
            }
                

            // Load variants
            jQuery('#text_subset').find('option').remove();
            jQuery('#text_subset').append('<option value="">Default</option>');
            jQuery.each(font.subsets,function(key, value) 
            {
                jQuery('#text_subset').append('<option value=' + value.id + '>' + value.name + '</option>');
            });

            if(text_subset != ''){
                jQuery('#text_subset').val(text_subset);  
            }else{
                jQuery('#text_subset').val('');  
            }

        }else{
            // Load default weights
            jQuery('#text_weight').find('option').remove();
            jQuery('#text_weight').append('<option value="400">Normal 400</option');
            jQuery('#text_weight').append('<option value="700">Bold 700</option');
            jQuery('#text_weight').append('<option value="400italic">Normal 400 Italic</option');
            jQuery('#text_weight').append('<option value="700italic">Bold 700 Italic</option');
            jQuery('#text_weight').val('400');

            jQuery('#text_subset').parent().fadeOut();
        }
    }

    jQuery(function () {
    set_text_font_extras(jQuery('#text_font'));
    // jQuery('#text_weight').val('400');
    // jQuery('#text_subset').val('');
    });

    jQuery('#text_font').on("change", function (e) { 
        el =jQuery('#text_font');

        set_text_font_extras(el);

        // Show Preview
        if(jQuery(el).val().indexOf(',') === -1){
        jQuery('#preview').contents().find('.gf-text').remove();
        url = 'https://fonts.googleapis.com/css?family='+jQuery(el).val().replace(/\'/g, "").replace(/\s/g, "+")+':'+jQuery('#text_weight').val()+'&subset='+jQuery('#text_subset').val();
        jQuery('#preview').contents().find('head').append('<link class="gf-text" rel="stylesheet" href="'+url+'" type="text/css" />');
        }


        // Body Font
        jQuery('#preview').contents().find('body, p,.login form').css('font-family',jQuery(el).val());

        // Placeholder Update
        jQuery('#preview').contents().find('tmp-placeholder-style').remove();
        jQuery('#preview').contents().find('head').append("<style id='tmp-placeholder-style' type='text/css'> .placeholder::-webkit-input-placeholder {font-family:"+jQuery('#text_font').val()+";font-weight:"+jQuery('#text_weight').val().replace(/[a-zA-Z]/g, "")+";font-style:"+jQuery('#text_weight').val().replace(/[0-9]/g, "")+";} </style>");
        jQuery('#preview').contents().find('input').addClass('placeholder');

        jQuery('#preview').contents().find('body, p,.login form').css('font-weight',parseInt(jQuery('#text_weight').val()));

        style = jQuery('#text_weight').val().replace(/[0-9]/g, '');
        if(style != ""){
            jQuery('#preview').contents().find('body, p,.login form').css('font-style',style);
        }else{
            jQuery('#preview').contents().find('body, p,.login form').css('font-style','normal');
        }



        //Save
        save_page(false);
        
    });

    jQuery('#text_weight').on("change", function (e) { 
        el =jQuery('#text_font');
        if(jQuery(el).val().indexOf(',') === -1){
        jQuery(".gf-text").remove();
        url = 'https://fonts.googleapis.com/css?family='+jQuery(el).val().replace(/\'/g, "").replace(/\s/g, "+")+':'+jQuery('#text_weight').val()+'&subset='+jQuery('#text_subset').val();
        jQuery('#preview').contents().find('head').append('<link class="gf-text" rel="stylesheet" href="'+url+'" type="text/css" />');
        }

        jQuery('#preview').contents().find('body, p,.login form').css('font-weight',parseInt(jQuery('#text_weight').val()));
        style = jQuery('#text_weight').val().replace(/[0-9]/g, '');
        if(style == ""){
            style = 'normal'
        }
        jQuery('#preview').contents().find('body, p,.login form').css('font-style',style);
        
        // Placeholder Update
        jQuery('#preview').contents().find('tmp-placeholder-style').remove();
        jQuery('#preview').contents().find('head').append("<style id='tmp-placeholder-style' type='text/css'> .placeholder::-webkit-input-placeholder {font-family:"+jQuery('#text_font').val()+";font-weight:"+jQuery('#text_weight').val().replace(/[a-zA-Z]/g, "")+";font-style:"+style+";} </style>");
        jQuery('#preview').contents().find('input').addClass('placeholder');



        //Save
        save_page(false);
    });

    jQuery('#text_subset').on("change", function (e) { 
        el =jQuery('#text_font');
        if(jQuery(el).val().indexOf(',') === -1){
        jQuery(".gf-text").remove();
        url = 'https://fonts.googleapis.com/css?family='+jQuery(el).val().replace(/\'/g, "").replace(/\s/g, "+")+':'+jQuery('#text_weight').val()+'&subset='+jQuery('#text_subset').val();
        jQuery('#preview').contents().find('head').append('<link class="gf-text" rel="stylesheet" href="'+url+'" type="text/css" />');
        }
    //Save
        save_page(false);
    });

jQuery(document).ready(function() {

      jQuery("#text_size_slider").noUiSlider({
            start: text_size,
            connect: "lower",
            step: 1,
            range: {
                'min': 10,
                'max': 100
            },
            format: wNumb({
                decimals: 0
            })
        });

        jQuery("#text_size_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
            // The tooltip HTML is 'this', so additional
            // markup can be inserted here.
            jQuery(this).html(
                '<div class="tooltip-inner">' +
                '<span>' + value + 'px</span>' +
                '</div>'
            );
            jQuery('#text_size').val(value);
            jQuery('#preview').contents().find('body, p, .login label,.login form,.wp-core-ui .button, .wp-core-ui .button-primary, .wp-core-ui .button-secondary,.login form .forgetmenot label,a').css('font-size',value + 'px');
            jQuery('#preview').contents().find('.wp-core-ui .button.button-large, .wp-core-ui .button-group.button-large .button').css('height',((value*2)+2) + 'px');

        });

           jQuery("#text_line_height_slider").noUiSlider({
            start: text_line_height,
            connect: "lower",
            step: 0.01,
            range: {
                'min': 0.5,
                'max': 2
            }
        });


            

        jQuery("#text_line_height_slider").Link('lower').to('-inline-<div class="tooltip fade top in" style="top: -33px;left: -7px;opacity: 0.7;"></div>', function(value) {
            // The tooltip HTML is 'this', so additional
            // markup can be inserted here.
            jQuery(this).html(
                '<div class="tooltip-inner">' +
                '<span>' + value + 'em</span>' +
                '</div>'
            );
            jQuery('#text_line_height').val(value);
            jQuery('#preview').contents().find('body, p, .login label,.login form,.wp-core-ui .button, .wp-core-ui .button-primary, .wp-core-ui .button-secondary,.login form .forgetmenot label,a').css('line-height',value + 'em');

        });

         });





      // Disabled unused fields
      jQuery( document ).ready(function($) {
         var disabled_fields = $('#disabled_fields').val();
         $(disabled_fields).off().prop('readonly',true).parents('.form-group').css({'opacity':'0.5','position':'relative'}).prepend( "<small class='seed_clp_disabled'>Not available in this theme!</small><br>" );
      });











