<?php
/**
 * Config
 *
 * @package WordPress
 * @subpackage seed_clp
 * @since 0.1.0
 */

/**
 * Config Settings
 */
function seed_clp_get_options(){

    /**
     * Create new menus
     */

    $seed_clp_options[ ] = array(
        "type" => "menu",
        "menu_type" => "add_options_page",
        "page_name" => __( "Login Page", 'seedprod-login-page-pro' ),
        "menu_slug" => "seed_clp",
        "layout" => "2-col"
    );

    /**
     * Settings Tab
     */
    $seed_clp_options[ ] = array(
        "type" => "tab",
        "id" => "seed_clp_setting",
        "label" => __( "Login Page Settings", 'seedprod-login-page-pro' ),
        "icon" => 'fa fa-sign-in',
    );

    $seed_clp_options[ ] = array(
        "type" => "setting",
        "id" => "seed_clp_settings_content",
    );

    $seed_clp_options[ ] = array(
        "type" => "section",
        "id" => "seed_clp_section_general",
        "label" => __( "General Settings", 'seedprod-login-page-pro' ),
        "icon" => 'fa fa-cogs',
    );

    $seed_clp_options[ ] = array(
        "type" => "custom_status",
        "id" => "status",
        "label" => __( "Status", 'seedprod-login-page-pro' ),
        "option_values" => array(
            '0' => __( 'Disabled', 'seedprod-login-page-pro' ),
            '1' => __( 'Enable Custom Login Page', 'seedprod-login-page-pro' ),
        ),
        //"desc" => __( "Enable the Customized Login Page", 'seedprod-login-page-pro' ),
        "default_value" => "0"
    );
    
    $seed_clp_options[ ] = array(
        "type" => "custom_editpage",
        "id" => "edit_page",
        "label" => __( "", 'seedprod-login-page-pro' ),

    );





    




    return $seed_clp_options;

}
