<?php
/**
 * Config
 *
 * @package WordPress
 * @subpackage seed_s404p
 * @since 0.1.0
 */

/**
 * Config Settings
 */
function seed_s404p_get_options(){

    /**
     * Create new menus
     */

    $seed_s404p_options[ ] = array(
        "type" => "menu",
        "menu_type" => "add_options_page",
        "page_name" => __( "404 Page Pro", 'seedprod-404-page-pro' ),
        "menu_slug" => "seed_s404p",
        "layout" => "2-col"
    );

    /**
     * Settings Tab
     */
    $seed_s404p_options[ ] = array(
        "type" => "tab",
        "id" => "seed_s404p_setting",
        "label" => __( "404 Page", 'seedprod-404-page-pro' ),
        "icon" => 'fa fa-clock-o',
    );

    $seed_s404p_options[ ] = array(
        "type" => "setting",
        "id" => "seed_s404p_settings_content",
    );

    $seed_s404p_options[ ] = array(
        "type" => "section",
        "id" => "seed_s404p_section_general",
        "label" => __( "General Settings", 'seedprod-404-page-pro' ),
        "icon" => 'fa fa-cogs',
    );

    $seed_s404p_options[ ] = array(
        "type" => "custom_status",
        "id" => "status",
        "label" => __( "Status", 'seedprod-404-page-pro' ),
        "option_values" => array(
            '0' => __( 'Disabled', 'seedprod-404-page-pro' ),
            '1' => __( 'Enable 404 Page Mode', 'seedprod-404-page-pro' ),
            '3' => __( 'Enable Redirect Mode', 'seedprod-404-page-pro' )
        ),
        "desc" => __( "<strong>404 Page Mode</strong> will replace your themes 404 page with a custom 404 page.<br><strong>Redirect Mode</strong> will create a 301 redirect for all your 404 pages.", 'seedprod-404-page-pro' ),
        "default_value" => "0"
    );
    
    $seed_s404p_options[ ] = array(
        "type" => "custom_editpage",
        "id" => "edit_page",
        "label" => __( "", 'seedprod-404-page-pro' ),

    );




   
    // Scripts
    $seed_s404p_options[ ] = array(
        "type" => "section",
        "id" => "seed_s404p_section_scripts",
        "label" => __( "Advanced Settings", 'seedprod-404-page-pro' ),
        "icon" => 'fa fa-code',
    );




    $seed_s404p_options[ ] = array(
        "type" => "radio",
        "id" => "include_exclude_options",
        "label" => __( "Exclude URLs", 'seedprod-404-page-pro' ),
        "desc" => __("By default the 404 page is shown on every url that is not found. Use the <strong>'Exclude URLs'</strong> option to only exlcude certain url from showing the 404 page.", 'seedprod-404-page-pro'),
        "option_values" => array(
             '0' => __( 'Show on every Not Found page.', 'seedprod-404-page-pro' ),
             '3' => __( 'Exclude URLs', 'seedprod-404-page-pro' ),
        ),
    );


    $seed_s404p_options[ ] = array(
        'id'        => 'include_url_pattern',
        'type'      => 'textarea',
        'label'     => __( "Include URLs", 'seedprod' ),
        'desc'  => __( 'Include certain urls to display the Coming Soon or Maintenance Page. One per line.', 'seedprod' ),
        'class' => 'large-text'
    );

    $seed_s404p_options[ ] = array(
        'id'        => 'exclude_url_pattern',
        'type'      => 'textarea',
        'label'     => __( "Exclude URLs", 'seedprod' ),
        'desc'  => __( 'Exclude certain urls from displaying the Coming Soon or Maintenance Page. One per line.', 'seedprod' ),
        'class' => 'large-text'
    );

  



    /**
     * Subscribers Tab
     */
    
    $seed_s404p_options[ ] = array(
        "type" => "tab",
        "id" => "seed_s404p_tab_subscribers",
        "label" => __( "Subscribers", 'seedprod-404-page-pro' ),
        "icon" => 'fa fa-users',
    );


    return $seed_s404p_options;

}
