<?php
/*
Plugin Name: Codex Themes Import
Plugin URI: http://codex-themes.com/themes/
Author: Codex Themes
Version: 1.0.5
Author URI: http://codex-themes.com/themes/
*/


include_once ('inc/parse_content.php');
include_once ('inc/import-widgets.php');
include_once ('inc/easy-mailchimp-import.php');

function ct_import_get_purchase() {
	if(!defined('ENVATO_HOSTED_SITE')) {
		$theme_options = get_option('ct_theme_options');
		if($theme_options && isset($theme_options['purchase_code'])) {
			return $theme_options['purchase_code'];
		}
	} else {
		return 'envato_hosted:'.(defined('SUBSCRIPTION_CODE') ? SUBSCRIPTION_CODE : '');
	}
	return false;
}

if(!function_exists('ct_is_plugin_active')) {
	function ct_is_plugin_active($plugin) {
		include_once(ABSPATH . 'wp-admin/includes/plugin.php');
		return is_plugin_active($plugin);
	}
}

add_action('admin_menu', 'ct_import_menu_page');
function ct_import_menu_page() {
	$ct_import_page_title = apply_filters('ct_import_page_title', 'Codex Themes Import');
	$ct_import_menu_title = apply_filters('ct_import_menu_title', 'Codex Themes Import');
	add_menu_page($ct_import_page_title , $ct_import_menu_title, 'manage_options', 'ct-import-submenu-page', 'ct_import_page', '', 81 );
}

function ct_import_page() {
	$packs = apply_filters('ct_import_packs', array());
	$ct_import_page_title = apply_filters('ct_import_page_title', 'Codex Themes Import');
?>
<div class="wrap">
	<div id="icon-tools" class="icon32"></div>
	<h2><?php echo $ct_import_page_title; ?></h2>
	<?php if(ct_is_plugin_active('wordpress-importer/wordpress-importer.php')) : ?>
		<p><?php printf(__('It seems that Wordpress Import Plugin is active. Please deactivate Wordpress Import Plugin on <a href="%s">plugins page</a> to proceed with import of Codex Themes\'s main demo content.'), admin_url('plugins.php')); ?></p>
	<?php elseif(!defined('CT_THEME_IMPORT_CHECK')) : ?>
		<p><?php _e('Your current activated theme in not Codex Themes theme. Please note, that this import works only with Codex Themes main parent theme. Please activate Codex Themes main parent theme before proceeding with import.'); ?></p>
	<?php elseif(!ct_is_plugin_active('ct-elements/ct-elements.php')) : ?>
		<p><?php _e('Plugin "Codex Themes Elements" is not active.'); ?></p>
	<?php elseif(!ct_import_get_purchase() && defined('CT_THEME_IMPORT_NEED_ACTIVATION')) : ?>
		<?php if(!defined('ENVATO_HOSTED_SITE')) : ?>
			<p><?php printf(__('Please enter purchase code in <a href="%s">Theme options</a>'), admin_url('themes.php?page=options-framework#activation')); ?></p>
		<?php endif; ?>
	<?php else : ?>
		<div class="ct-import-prevent-message"><?php printf(__('The import of demo media works best on a new installation of WordPress. If you have already an existing WordPress installation, we recommend you to use "<a href="%s" target="_blank">Reset WP</a>" plugin to reset your media database and content.'), esc_url('https://wordpress.org/plugins/reset-wp/')); ?></div>
		<div class="ct-import-output ui-no-theme">
			<div class="import-variants">

				<?php if(defined('CT_THEME_IMPORT_CONCEPT_CHECK')) : ?>
					<div id="pack-import" class="import-variant">
						<h3><?php _e('Import of selected demo concepts'); ?></h3>
						<div class="inside"><div>
								<p><?php _e('Lightweighted import option. Here you can select one purpose topic for demo import. It is useful if you are interested only in one special puprose (for example only business homepages) and don\'t need any other demos. This import will install only homepages of the selected topic as well as demo pages from "Pages" category of our demo website (About Us, Services etc.) and demo pages from "Elements" category (to give you all examples of how to use different shortcodes and elements). Please note: this import works best on a new intall of WordPress.'); ?></p>
								<div class="import-tabs">
									<ul class="clearfix">
										<?php foreach($packs as $pack => $content) : ?>
											<li><a href="#import-tab-<?php echo $pack; ?>"><?php echo $content['title']; ?></a></li>
										<?php endforeach; ?>
									</ul>
									<div class="import-tabs-content">
										<?php foreach($packs as $pack => $content) : ?>
											<div class="import-tab" id="import-tab-<?php echo $pack; ?>">
												<?php if(!isset($content['multi'])) : ?>
												<?php if(isset($content['message'])) : ?>
													<div class="import-pack-message"><?php echo $content['message']; ?></div>
												<?php endif; ?>
													<div class="import-pack-pics">
														<?php foreach($content['pics'] as $pic) : ?>
															<div class="import-pack-pic"><img src="<?php echo esc_url($pic); ?>" alt="#" /></div>
														<?php endforeach; ?>
													</div>
													<button class="import-button button-primary" data-import-part="full" data-import-pack="<?php echo $pack; ?>"><?php _e('Import'); ?></button>
												<?php else : ?>
												<?php if(isset($content['message'])) : ?>
													<div class="import-pack-message"><?php echo $content['message']; ?></div>
												<?php endif; ?>
													<div class="import-pack-pics multi-pack">
														<?php foreach($content['multi'] as $mpack => $pic) : ?>
															<div class="import-pack-pic">
																<img src="<?php echo esc_url($pic); ?>" alt="#" /><br />
																<button class="import-button button-primary" data-import-part="full" data-import-pack="<?php echo $mpack; ?>"><?php _e('Import'); ?></button>
															</div>
														<?php endforeach; ?>
													</div>
												<?php endif; ?>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
						</div></div>
					</div>
				<?php endif; ?>


				<?php if(defined('CT_THEME_IMPORT_FULL_CHECK')) : ?>

				<div id="singles-import" class="import-variant">
					<h3><?php _e('Import of single pages, posts etc.'); ?></h3>
					<div class="inside">
						<div>
														<?php

														$file = apply_filters('ct_inport_content_singles_json_file', plugins_url('/demo-files/content_singles.json', __FILE__));
														if($file_content = file_get_contents($file)) {
																$singles_content = json_decode($file_content, true);

																$homepage_array = isset($singles_content['homepages']) ? sort_array_for_single_item($singles_content['homepages']) : array();
																$page_array = isset($singles_content['pages']) ? sort_array_for_single_item($singles_content['pages']) : array();
																$post_array = isset($singles_content['posts']) ? sort_array_for_single_item($singles_content['posts']) : array();
																$portfolio_array = isset($singles_content['portfolios']) ? sort_array_for_single_item($singles_content['portfolios']) : array();
																$product_array = isset($singles_content['products']) ? sort_array_for_single_item($singles_content['products']) : array();

																$is_woocommerce = class_exists( 'WooCommerce' );

																function get_single_item_elem($array, $name) {
																		echo '<ul>';
																		foreach ($array as $item) {
																				if(!empty($item['children'])) {
																						echo '<li><div class="import-single-item-parent">'.$item['parent'].'</div>';
																						get_single_item_elem($item['children'], $name);
																						echo '</li>';
																				} else {
																						echo '<li><div class="import-single-item-elem">';
																						echo '<input name="'.$name.'[]" value="'.implode(',', $item['ids']).'" data-id="'.$item['id'].'" data-src="'.plugins_url('/images/thumbs/'.$name.'/'.$item['id'].'.jpg' , __FILE__ ).'" type="checkbox">';
																						$title = $name=='homepage' ? str_replace('Homepage:','',$item['title']) : $item['title'];
																						echo '<div class="import-single-item-elem-title">'.trim($title).'</div>';
																						echo '</div></li>';
																				}
																		}
																		echo '</ul>';
																}

																?>

																<form class="single-import-form import-singles">
																		<div class="import-singles-box">
																				<div class="import-single-col">
																						<div class="import-single-col-title">Homepages</div>
																						<div class="import-single-col-body homepages">
																								<?php get_single_item_elem($homepage_array, 'homepage'); ?>
																						</div>
																				</div>
																				<div class="import-single-col">
																						<div class="import-single-col-title">Pages</div>
																						<div class="import-single-col-body pages">
																								<?php get_single_item_elem($page_array, 'page'); ?>
																						</div>
																				</div>
																				<div class="import-single-col">
																						<div class="import-single-col-title">Posts</div>
																						<div class="import-single-col-body posts">
																								<?php get_single_item_elem($post_array, 'post'); ?>
																						</div>
																				</div>
																				<div class="import-single-col">
																						<div class="import-single-col-title">Portfolio</div>
																						<div class="import-single-col-body portfolios">
																								<?php get_single_item_elem($portfolio_array, 'portfolio'); ?>
																						</div>
																				</div>
																				<?php if($is_woocommerce && $product_array) { ?>
																						<div class="import-single-col">
																								<div class="import-single-col-title">Products</div>
																								<div class="import-single-col-body products">
																										<?php get_single_item_elem($product_array, 'product'); ?>
																								</div>
																						</div>
																				<?php } ?>
																		</div>

																		<div class="import-singles-preview-box"></div>

																		<div class="import-singles-btn-box">
																				<input class="import-singles-button button-primary" type="submit" value="Import" />
																		</div>

																</form>

														<?php } ?>
						</div>
					</div>
				</div>

				<?php endif; ?>


				<?php if(defined('CT_THEME_IMPORT_FULL_CHECK')) : ?>
					<div id="full-import" class="import-variant">
							<h3><?php _e('Full demo import'); ?></h3>
							<div class="inside">
									<div>
											<p><?php _e('With this option you can import all demo content with one click, including import of media content (selected and optimized images & videos used on our demo website). Please note: full import & generating of image thumbnails may take from 30 min to 1 hour, depending on your server/hosting configuration.'); ?></p>
											<button class="import-button button-primary" data-import-part="full" data-import-pack="main"><?php _e('Start full demo import'); ?></button>
									</div>
							</div>
					</div>
				<?php endif; ?>

				<?php if(defined('CT_THEME_IMPORT_REMOVE_CHECK')) : ?>
					<div id="remove-demo-content" class="import-variant">
							<h3><?php _e('Remove demo content'); ?></h3>
							<div class="inside">
									<div>
											<p><?php _e('With this option you can remove all demo content, which you have imported and which you have not modified.'); ?></p>
											<p><?php _e('IMPORTANT: In case you have edited (and saved) some posts, pages etc., this content will not be removed. This concerns media content as well. If you wish to keep some demo media on your website, you need to remove the word „(Demo)“ from the media description of the corresponding media file (image, video etc), otherwise this file will be removed as well.'); ?></p>
											<button id="btn-remove-demo-content" type="button" class="button-primary"><?php _e('Remove demo content'); ?></button>
									</div>
							</div>
					</div>
				<?php endif; ?>

				<?php if(defined('CT_THEME_IMPORT_WIDGET_CHECK')) : ?>
					<div id="widgets-import" class="import-variant">
							<h3><?php _e('Import demo widgets'); ?></h3>
							<div class="inside">
									<div>
											<p><?php _e('Here you can import all demo widgets we have used on our demo website. '); ?></p>
											<button id="btn-import-widgets" type="button" class="button-primary"><?php _e('Import demo widgets'); ?></button>
									</div>
							</div>
					</div>
				<?php endif; ?>

				<?php $is_easy_mailChimp = class_exists('Yikes_Inc_Easy_MailChimp_Import_Class');
						if(defined('CT_THEME_IMPORT_MAILCHIMP_CHECK') && $is_easy_mailChimp) { ?>
						<div id="mailchimp-forms-import" class="import-variant">
								<h3><?php _e('Import newsletter forms'); ?></h3>
								<div class="inside">
										<div>
												<p><?php _e('Here you can import all newsletter subscription forms used on our demo website.'); ?></p>
												<button id="btn-import-mailchimp-forms" type="button" class="button-primary"><?php _e('Import newsletter forms'); ?></button>
										</div>
								</div>
						</div>
				<?php } ?>

			</div>
		</div>
	<?php endif; ?>
</div>
<?php
}

function ct_import_enqueue($hook) {
	if($hook == 'toplevel_page_ct-import-submenu-page') {
		wp_enqueue_script('ct-import-scripts', plugins_url( '/js/cti-scripts.js' , __FILE__ ), array('jquery', 'jquery-ui-accordion', 'jquery-ui-tabs'), false, true);
		wp_localize_script('ct-import-scripts', 'ct_import_data', array(
			'ajax_url' => admin_url('admin-ajax.php')
		));
		wp_enqueue_style('ct-import-css', plugins_url( '/css/cti-styles.css' , __FILE__ ));
	}
}
add_action('admin_enqueue_scripts', 'ct_import_enqueue');

add_action('wp_ajax_ct_import_files_list', 'ct_import_files_list');
function ct_import_files_list () {
	$response_p = wp_remote_get(add_query_arg(array('code' => ct_import_get_purchase(), 'site_url' => get_site_url()), 'http://democontent.codex-themes.com/av_validate_code'.(defined('ENVATO_HOSTED_SITE') ? '_envato' : '').'.php'), array('timeout' => 20));
	if(!is_wp_error($response_p) || !defined('CT_THEME_IMPORT_NEED_ACTIVATION')) {
		$rp_data = json_decode($response_p['body'], true);
		if(!defined('CT_THEME_IMPORT_NEED_ACTIVATION') || is_array($rp_data) && isset($rp_data['result']) && $rp_data['result'] && isset($rp_data['item_id']) && defined('CT_THEME_ENVATO_ID') && $rp_data['item_id'] == CT_THEME_ENVATO_ID) {
			if(isset($_REQUEST['import_pack']) && isset($_REQUEST['import_part'])) {
				$response = wp_remote_get(add_query_arg(array('import_pack' => $_REQUEST['import_pack'], 'import_part' => $_REQUEST['import_part']), apply_filters('ct_import_index_link', 'http://democontent.codex-themes.com/ct-import-packs/index.php')), array('timeout' => 20));
				if(!is_wp_error($response)) {
					echo $response['body'];
					if($_REQUEST['import_part']=='posts') {
						update_option('import_attachment_json_data', ct_get_attachment_json_data());
					}
				} else {
					echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Some troubles with connecting to demo-content server.'));
				}
			} else {
				echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Sending data error.'));
			}
		} else {
			if(!defined('ENVATO_HOSTED_SITE')) {
					echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Purchase code verification failed. <a href="'.esc_url(admin_url('themes.php?page=options-framework#activation')).'">Activate Codex Theme</a>'));
			} else {
				echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Verification failed.'));
			}
		}
	} else {
		echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Some troubles with connecting to demo-content server.'));
	}
	die(-1);
}

add_action('wp_ajax_ct_import_sliders_list', 'ct_import_sliders_list');
function ct_import_sliders_list () {
	$sliders = get_option('ct_revsliders_for_import');
	$sliders = !empty($sliders) && is_array($sliders) ? array_values(array_unique($sliders)) : array();
	echo json_encode(array('status' => 1, 'status_text' => 'Sliders import is running. Please don\'t close this window until import is finished.', 'message' => 'Importing sliders', 'files_list' => $sliders));
	die(-1);
}

add_action('wp_ajax_ct_import_file', 'ct_import_file');
function ct_import_file () {
	$filedir = apply_filters('ct_import_pack_files_directory', '/ct-import-packs/');
	if(isset($_REQUEST['import_pack']) && ($_REQUEST['import_pack'] !== 'main')) {
		$filedir = $filedir.$_REQUEST['import_pack'].'/';
	}

	if(!empty($_REQUEST['filename'])) {
		ob_start();
		require_once(ABSPATH . 'wp-admin/includes/file.php');
		$tmp = download_url('http://democontent.codex-themes.com/'.$filedir.$_REQUEST['filename']);
		if( is_wp_error( $tmp ) ) {
			print_r('http://democontent.codex-themes.com/'.$filedir.$_REQUEST['filename']);
			print_r($tmp->get_error_messages());
		} else {
			if (! defined('WP_LOAD_IMPORTERS')) define('WP_LOAD_IMPORTERS', true);
			require_once(plugin_dir_path( __FILE__ ) . '/inc/wordpress-importer.php');
			$wp_import = new WP_Import();
			$wp_import->fetch_attachments = true;
			$wp_import->import($tmp);
		}
		@unlink( $tmp );
		$messages = ob_get_clean();
		echo json_encode(array('status' => 1, 'message' => 'Done. <!-- '.$messages.' -->'));
	}
	die(-1);
}

add_action('wp_ajax_ct_import_slider', 'ct_import_slider');
function ct_import_slider () {
	if(!empty($_REQUEST['alias'])) {
		ob_start();
		$result = ct_import_revslider($_REQUEST['alias']);
		echo $result['message'];
		$messages = ob_get_clean();
		echo json_encode(array('status' => 1, 'message' => 'Done. <!-- '.$messages.' -->'));
	}
	die(-1);
}

function ct_import_replace_array($dir = 1) {
	$packs = apply_filters('ct_import_replace_packs', array());
	if($dir === 1) {
		$replace_array = array('http://democontent.codex-themes.com/themes/wp-content/uploads');
	} else {
		$replace_array = array('http://democontent.codex-themes.com/themes/wp-content/themes');
	}
	foreach($packs as $pack) {
		if($dir === 1) {
			$replace_array[] = 'http://democontent.codex-themes.com/themes/'.$pack.'/wp-content/uploads';
		} else {
			$replace_array[] = 'http://democontent.codex-themes.com/themes/'.$pack.'/wp-content/themes';
		}
	}
	return apply_filters('ct_import_replace_array', $replace_array, $dir);
}

add_filter('wp_import_post_data_raw', 'ct_import_wp_import_post_data_raw');
function ct_import_wp_import_post_data_raw($post) {
	$upload_dir = wp_upload_dir();
	$post['post_content'] = str_replace(ct_import_replace_array(), $upload_dir['baseurl'], $post['post_content']);
	$post['post_content'] = str_replace(ct_import_replace_array(2), get_theme_root_uri(), $post['post_content']);

	if($post['post_type'] != 'nav_menu_item') {
				$post['post_title'] = $post['post_title'].' (Demo)';
		}

	if(!empty($post['post_content'])) {
		$attachments_data = get_option('import_attachment_json_data');
		if(!empty($attachments_data)) {
			$post['post_content'] = ct_replace_attachments_content($post['post_content'], $attachments_data);
		}
	}

	return $post;
}

add_filter('wp_import_post_terms', 'ct_wp_import_terms');
function ct_wp_import_terms($terms) {
		if(!empty($terms)) {
				foreach ($terms as $key => $value) {
						$terms[$key]['name']=$terms[$key]['name'].' (Demo)';
				}
		}
		return $terms;
}

add_action( 'wp_import_insert_post', 'ct_wp_import_insert_post', 10, 4 );
function ct_wp_import_insert_post($post_id, $original_post_ID, $postdata, $post) {

		if(get_option('ct_is_import_singles')) {
				$ct_import_singles_ids = get_option('ct_import_singles_ids');
				if(!empty($ct_import_singles_ids)) {
						$ct_import_singles_ids[] = $post_id;
						update_option('ct_import_singles_ids', $ct_import_singles_ids);
				} else {
						update_option('ct_import_singles_ids', array($post_id));
				}

		}
}


add_filter('import_post_meta', 'ct_import_post_meta', 11, 3);
function ct_import_post_meta($post_id, $key, $value) {
	$upload_dir = wp_upload_dir();
	if(is_array($value)) {
		foreach($value as $k => $v) {
			if(is_array($v)) {
				foreach($v as $a => $b) {
					$value[$k][$a] = str_replace(ct_import_replace_array(), $upload_dir['baseurl'], $value[$k][$a]);
					$value[$k][$a] = str_replace(ct_import_replace_array(2), get_theme_root_uri(), $value[$k][$a]);
				}
			} else {
				$value[$k] = str_replace(ct_import_replace_array(), $upload_dir['baseurl'], $value[$k]);
				$value[$k] = str_replace(ct_import_replace_array(2), get_theme_root_uri(), $value[$k]);
			}
		}
	} else {
		$value = str_replace(ct_import_replace_array(), $upload_dir['baseurl'], $value);
		$value = str_replace(ct_import_replace_array(2), get_theme_root_uri(), $value);
	}
	if($key == 'ct_page_data' && is_array($value)) {
		if(!empty($value['slideshow_type']) && $value['slideshow_type'] == 'revslider' && !empty($value['slideshow_revslider'])) {
			$sliders = get_option('ct_revsliders_for_import');
			$sliders = !empty($sliders) && is_array($sliders) ? array_values(array_unique($sliders)) : array();
			$sliders[] = $value['slideshow_revslider'];
			update_option('ct_revsliders_for_import', $sliders);
		}
	}
	update_post_meta($post_id, $key, $value);
}

function ct_import_revslider($alias) {
	$slider_link = ct_import_slider_link($alias);
	if(!empty($slider_link)) {
		if (class_exists( 'RevSlider' ) ) {
			$slider = new RevSlider();
			if(!$slider->isAliasExists($alias)) {
				require_once(ABSPATH . 'wp-admin/includes/file.php');
				$tmp = download_url($slider_link);
				if( is_wp_error( $tmp ) ) {
					return array('status' => false, 'message' => 'Can\'t download slider archive: '.$tmp->get_error_messages());
				} else {
					$result = $slider->importSliderFromPost(true,true,$tmp);
					return array('status' => true, 'message' => 'Import result: '.print_r($result, 1));
				}
			} else {
				return array('status' => false, 'message' => 'Slider with alias "'.$alias.'" is exists.');
			}
		} else {
			return array('status' => false, 'message' => 'RevSlider plugin not installed.');
		}
	} else {
		return array('status' => false, 'message' => 'Alias "'.$alias.'" not found.');
	}
}

function ct_import_slider_link($slider) {
	$sliders = apply_filters('ct_import_sliders', array());

	return !empty($sliders[$slider]) ? $sliders[$slider] : false;
}

add_action('wp_ajax_ct_delete_attachment_json_data', 'ct_delete_attachment_json_data');
function ct_delete_attachment_json_data() {
	delete_option('import_attachment_json_data');
	delete_option('ct_revsliders_for_import');
}

add_action('wp_ajax_ct_import_singles', 'ct_import_singles');
function ct_import_singles() {
		$response_p = wp_remote_get(add_query_arg(array('code' => ct_import_get_purchase(), 'site_url' => get_site_url()), 'http://democontent.codex-themes.com/av_validate_code'.(defined('ENVATO_HOSTED_SITE') ? '_envato' : '').'.php'), array('timeout' => 20));
		if(!defined('CT_THEME_IMPORT_NEED_ACTIVATION') || !is_wp_error($response_p)) {
				$rp_data = json_decode($response_p['body'], true);
				if(!defined('CT_THEME_IMPORT_NEED_ACTIVATION') || is_array($rp_data) && isset($rp_data['result']) && $rp_data['result'] && isset($rp_data['item_id']) && defined('CT_THEME_ENVATO_ID') && $rp_data['item_id'] == CT_THEME_ENVATO_ID) {
						if(isset($_REQUEST['ids']) && !empty($_REQUEST['ids'])) {
								$ids = ct_parse_ids_request($_REQUEST['ids']);
								file_put_contents(ABSPATH.'ids.txt', print_r($ids, 1));
								$file_content = 'http://democontent.codex-themes.com/ct-import-packs/ct-singles/content.xml';
								ob_start();
								require_once(ABSPATH . 'wp-admin/includes/file.php');
								$tmp = download_url($file_content);
								if( is_wp_error( $tmp ) ) {
										print_r($tmp->get_error_messages());
								} else {
										if (! defined('WP_LOAD_IMPORTERS')) define('WP_LOAD_IMPORTERS', true);
										require_once(plugin_dir_path( __FILE__ ) . '/inc/wordpress-importer.php');
										$wp_import_single = new WP_Import();
										$wp_import_single->fetch_attachments = true;
										update_option('ct_is_import_singles', true);
										$wp_import_single->import($tmp, $ids);
								}
								@unlink( $tmp );
								$message = ob_get_clean();

								$import_ids = get_option('ct_import_singles_ids');
								delete_option('ct_is_import_singles');
								delete_option('ct_import_singles_ids');

								$sliders = get_option('ct_revsliders_for_import');
								$sliders = !empty($sliders) && is_array($sliders) ? array_values(array_unique($sliders)) : array();
								$slider_status = array();
								foreach($sliders as $alias) {
									$result = ct_import_revslider($alias);
									$slider_status[] = $result['message'];
								}
								delete_option('ct_revsliders_for_import');

								echo json_encode(array('status' => 1, 'data'=>$import_ids, 'message'=>$message, 'slider_status' => $slider_status));
						} else {
								echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Error on import: empty ids value.'));
						}
				} else {
						if(!defined('ENVATO_HOSTED_SITE')) {
								echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Purchase code verification failed. <a href="'.esc_url(admin_url('themes.php?page=options-framework#activation')).'">Activate Codex Theme</a>'));
						} else {
								echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Verification failed.'));
						}
				}
		} else {
				echo json_encode(array('status' => 0, 'status_text' => 'Import failed.', 'message' => 'Some troubles with connecting to demo-content server.'));
		}
		die(-1);
}


add_action('wp_ajax_ct_import_singles_update_content', 'ct_import_singles_update_content');
function ct_import_singles_update_content() {
	if(isset($_REQUEST['ids']) && !empty($_REQUEST['ids'])) {
		$ids = $_REQUEST['ids'];
		$attachments_data = ct_get_attachment_json_data('singles');
		$product_categories_data = ct_get_categories_product_json_data();

		$query = new WP_Query( array('post_status' => 'any', 'post_type' => 'any', 'post__in' => $ids, 'posts_per_page'=>-1) );
		while ( $query->have_posts() ) {
			$query->the_post();
			$p = get_post();
						if(get_post_type() != 'attachment' && !empty($p->post_content)) {
								$p->post_content = ct_replace_attachments_content($p->post_content, $attachments_data);
								$p->post_content = ct_replace_product_categories_content($p->post_content, $product_categories_data);
								wp_update_post($p);
						}
		}
		echo json_encode(array('status' => 1));
	}

	die(-1);
}

function ct_get_attachment_json_data($type='') {
		if($type=='singles') {
			$filedir = apply_filters('ct_import_pack_files_directory', '/ct-import-packs/singles/');
		} else {
				$filedir = apply_filters('ct_import_pack_files_directory', '/ct-import-packs/');
				if(isset($_REQUEST['import_pack']) && ($_REQUEST['import_pack'] !== 'main')) {
						$filedir = $filedir.$_REQUEST['import_pack'].'/';
				}
		}

		$filename = 'content_attachments.json';
		$data = array();
		$tmp = download_url('http://democontent.codex-themes.com/'.$filedir.$filename);

		if( is_wp_error( $tmp ) ) {
			print_r('http://democontent.codex-themes.com/'.$filedir.$filename);
			print_r($tmp->get_error_messages());
		} else {
				$file_content = file_get_contents($tmp);
				$file_data = json_decode($file_content, true);
				if(!empty($file_data)) {
						$data = ct_get_ids_attachment($file_data);
				}
				unlink($tmp);
		}

		return $data;
}


function ct_get_categories_product_json_data() {
		$data = array();
		$tmp = download_url('http://democontent.codex-themes.com/ct-import-packs/singles/content_product_categories.json');

		if( is_wp_error( $tmp ) ) {
			print_r('http://democontent.codex-themes.com/ct-import-packs/singles/content_product_categories.json');
			print_r($tmp->get_error_messages());
		} else {
				$file_content = file_get_contents($tmp);
				$file_data = json_decode($file_content, true);
				if(!empty($file_data)) {
						$data = ct_get_product_categories_ids($file_data);
				}
				unlink($tmp);
		}

		return $data;
}

add_action('wp_ajax_ct_remove_import_demo_content', 'ct_remove_import_demo_content');
function ct_remove_import_demo_content() {
		global $wpdb;
		$demo_prefix = $wpdb->esc_like('(Demo)');
		$demo_prefix = '%'.$demo_prefix.'%';

		//deleted attachments
		$sql = $wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_title LIKE %s AND post_type = %s", $demo_prefix, 'attachment');
		$attachments = $wpdb->get_results($sql, OBJECT);
		foreach ($attachments as $key => $value) {
				wp_delete_attachment($value->ID, true);
		}

		//deleted posts
		$sql = $wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_title LIKE %s", $demo_prefix);
		$posts = $wpdb->get_results($sql, OBJECT);
		foreach ($posts as $key => $value) {
				wp_delete_post($value->ID, true);
		}

		//deleted terms
		$sql = $wpdb->prepare("SELECT term_id FROM $wpdb->terms WHERE name LIKE %s", $demo_prefix);
		$terms = $wpdb->get_results($sql, OBJECT);
		foreach ($terms as $key => $value) {
				$term = get_term($value->term_id);
				wp_delete_term($term->term_id, $term->taxonomy);
		}

		die(-1);
}

function ct_import_widgets($file) {
	$response = file_get_contents($file);
	if($response) {
			$file_data = json_decode($response);
			$result = ct_widgets_import_data($file_data);
			}
	}

function ct_import_mailchimp_forms($file) {
	$result = ct_mailchimp_import_forms($file);
}

add_action('wp_ajax_ct_import_final', 'ct_import_final');
function ct_import_final () {
	$packs = apply_filters('ct_import_packs', array());
	if(isset($_REQUEST['import_pack']) && isset($packs[$_REQUEST['import_pack']])) {
		$pack = $packs[$_REQUEST['import_pack']];
		if(isset($pack['options']) && file_exists($pack['options'])) {
			$file_content = file_get_contents($pack['options']);
			$file_content = str_replace('{theme_path}', get_template_directory_uri(), $file_content);
			$options = json_decode($file_content, 1);
			$theme_options = get_option('ct_theme_options');
			if($theme_options && isset($theme_options['purchase_code'])) {
				$options['purchase_code'] = $theme_options['purchase_code'];
			}
			update_option('ct_theme_options', $options);
		}
		if(isset($pack['widgets']) && file_exists($pack['widgets'])) {
			ct_import_widgets($pack['widgets']);
		}
		if(isset($pack['mailchimp']) && file_exists($pack['mailchimp']) && defined( 'YIKES_MC_VERSION' )) {
			ct_import_mailchimp_forms($pack['mailchimp']);
		}
		if(isset($pack['homepage'])) {
			$front_page_id = get_page_by_title($pack['homepage'].' (Demo)');
			update_option( 'show_on_front', 'page' );
			update_option( 'page_on_front', $front_page_id->ID );
		}
		if(isset($pack['menus'])) {
			$menus = array();
			foreach($pack['menus'] as $position => $name) {
				$term = get_term_by( 'name', $name, 'nav_menu' );
				if($term) {
					$menus[$position] = $term->term_id;
				}
			}
			set_theme_mod('nav_menu_locations', $menus);
		}
	}
	echo json_encode(array('status' => 1, 'status_text' => 'Import success.'));
	die(-1);
}